/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.operation;

import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionProviderModel;
import com.mulesoft.connectivity.datacloud.internal.ConnectivityMessage;
import com.mulesoft.connectivity.datacloud.internal.connection.DataCloudConnection;
import com.mulesoft.connectivity.datacloud.internal.context.ExecutionContext;
import com.mulesoft.connectivity.datacloud.internal.operation.DataCloudParameters;
import com.mulesoft.connectivity.datacloud.internal.operation.DataProvider;
import com.mulesoft.connectivity.datacloud.internal.operation.ExecutionFunctionBuilder;
import com.mulesoft.connectivity.datacloud.internal.operation.ExecutionParameters;
import com.mulesoft.connectivity.datacloud.internal.operation.ExecutionUtils;
import com.mulesoft.connectivity.datacloud.internal.operation.OperationsIndex;
import com.mulesoft.connectivity.datacloud.internal.ratelimiter.RateLimitingConfiguration;
import com.mulesoft.connectivity.datacloud.internal.ratelimiter.RateLimitingPolicy;
import com.mulesoft.connectivity.datacloud.internal.retry.RetryConfiguration;
import com.mulesoft.connectivity.datacloud.internal.utils.FeatureGates;
import com.mulesoft.connectivity.datacloud.internal.utils.ObjectFlattener;
import com.mulesoft.connectivity.linkweave.api.interpreter.Connection;
import com.mulesoft.connectivity.linkweave.api.interpreter.Content;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.interpreter.Page;
import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import com.mulesoft.connectivity.linkweave.api.model.operation.ResultError;
import com.mulesoft.connectivity.linkweave.api.model.trigger.NextData;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerItem;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerPage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityCollectionProvider
implements DataProvider<ConnectivityMessage> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityCollectionProvider.class);
    private final String connectorName;
    private final ModelInterpreter modelInterpreter;
    private final DataCloudConnectionProviderModel connectionProviderModel;
    private final List<OperationsIndex.OperationWrapper> operations;
    private final RetryConfiguration retryConfiguration;
    private final RateLimitingPolicy rateLimitingPolicy;
    private final ObjectFlattener objectFlattener;

    public EntityCollectionProvider(String connectorName, @Nullable Map<String, Object> connectorConfiguration, ModelInterpreter modelInterpreter, DataCloudConnectionProviderModel connectionProviderModel, List<OperationsIndex.OperationWrapper> operations, RetryConfiguration retryConfiguration, RateLimitingPolicy rateLimitingPolicy) {
        this.connectorName = connectorName;
        this.modelInterpreter = modelInterpreter;
        this.connectionProviderModel = connectionProviderModel;
        this.operations = operations;
        this.retryConfiguration = retryConfiguration;
        this.rateLimitingPolicy = rateLimitingPolicy;
        Map dateFormats = connectorConfiguration != null ? (Map)connectorConfiguration.get("dateFormats") : null;
        this.objectFlattener = new ObjectFlattener(dateFormats);
    }

    @Override
    public void execute(DataCloudConnection connection, DataCloudParameters parameters, Consumer<ConnectivityMessage> recordConsumer) {
        this.execute(0, connection, parameters.getParameters(), parameters.getIncrementalParameters(), parameters.getFieldList(), recordConsumer);
    }

    private void execute(int executionStep, DataCloudConnection dataCloudConnection, Map<String, Object> parameters, Map<String, Object> incrementalAttributes, List<String> fieldList, Consumer<ConnectivityMessage> consumer) {
        OperationsIndex.OperationWrapper current = this.operations.get(executionStep);
        ExecutableComponentModel<?> executableComponentModel = current.operation();
        if (executableComponentModel instanceof TriggerModel) {
            TriggerModel triggerModel = (TriggerModel)executableComponentModel;
            log.debug("Executing trigger {}", current.operation());
            this.executeTrigger(executionStep, dataCloudConnection, parameters, incrementalAttributes, fieldList, consumer, triggerModel);
        } else {
            log.debug("Executing operation {}", current.operation());
            this.executeOperation(executionStep, dataCloudConnection, parameters, fieldList, incrementalAttributes, consumer, (OperationModel)current.operation());
        }
    }

    private void executeTrigger(int executionStep, DataCloudConnection dataCloudConnection, Map<String, Object> parameters, Map<String, Object> incrementalAttributes, List<String> fieldList, Consumer<ConnectivityMessage> consumer, TriggerModel triggerModel) {
        Optional<Serializable> nextPageParams;
        Object greatestWatermark = null;
        if (incrementalAttributes != null) {
            greatestWatermark = incrementalAttributes.get("greatestWatermark");
        }
        Object initialWatermark = greatestWatermark == null ? this.modelInterpreter.getInitialWatermark((Connection)Connection.of((BaseConnectionProviderModel)this.connectionProviderModel, dataCloudConnection.getParameters()), (BaseExecutableComponentModel)triggerModel, parameters) : greatestWatermark;
        ExecutionParameters executionParameters = ExecutionParameters.builder().connectionProviderModel(this.connectionProviderModel).executableModel((ExecutableComponentModel<?>)triggerModel).connectionInfo(dataCloudConnection.getParameters()).parameters(parameters).incrementalAttributes(incrementalAttributes).initialWatermark(initialWatermark).build();
        ExecutionFunctionBuilder.FunctionName operationType = ExecutionFunctionBuilder.FunctionName.TRIGGER;
        while (!(nextPageParams = this.executeAndProcessResult(executionStep, dataCloudConnection, operationType, executionParameters, fieldList, consumer)).isEmpty()) {
            executionParameters = executionParameters.toBuilder().parameters(nextPageParams.get()).build();
            operationType = ExecutionFunctionBuilder.FunctionName.TRIGGER_NEXT_PAGE;
        }
    }

    private void executeOperation(int executionStep, DataCloudConnection dataCloudConnection, Map<String, Object> parameters, List<String> fieldList, Map<String, Object> incrementalAttributes, Consumer<ConnectivityMessage> consumer, OperationModel operationModel) {
        OperationsIndex.OperationWrapper current = this.operations.get(executionStep);
        ExecutionParameters executionParameters = ExecutionParameters.builder().connectionProviderModel(this.connectionProviderModel).executableModel((ExecutableComponentModel<?>)operationModel).incrementalAttributes(incrementalAttributes).connectionInfo(dataCloudConnection.getParameters()).parameters(parameters).customHandler(current.customHandler()).build();
        if (operationModel.isPaginated()) {
            Optional<Serializable> nextPageParams;
            ExecutionFunctionBuilder.FunctionName operationType = ExecutionFunctionBuilder.FunctionName.OPERATION;
            while (!(nextPageParams = this.executeAndProcessResult(executionStep, dataCloudConnection, operationType, executionParameters, fieldList, consumer)).isEmpty()) {
                if (!(nextPageParams.get() instanceof Map)) {
                    throw new IllegalArgumentException("Next page parameters must be a map");
                }
                HashMap<String, Object> nextPageArgs = new HashMap<String, Object>(parameters);
                nextPageArgs.putAll((Map)((Object)nextPageParams.get()));
                executionParameters = executionParameters.toBuilder().parameters(nextPageArgs).build();
                operationType = ExecutionFunctionBuilder.FunctionName.OPERATION_NEXT_PAGE;
            }
        } else {
            this.executeAndProcessResult(executionStep, dataCloudConnection, ExecutionFunctionBuilder.FunctionName.OPERATION, executionParameters, fieldList, consumer);
        }
    }

    private Optional<Serializable> executeAndProcessResult(int executionStep, DataCloudConnection dataCloudConnection, ExecutionFunctionBuilder.FunctionName operationType, ExecutionParameters executionParameters, List<String> fieldList, Consumer<ConnectivityMessage> consumer) {
        OperationsIndex.OperationWrapper current = this.operations.get(executionStep);
        Function executionFunction = ExecutionFunctionBuilder.builder(this.modelInterpreter).build(operationType);
        RateLimitingConfiguration rateLimitingConfiguration = RateLimitingConfiguration.builder().operationRateLimitConfigurations(current.rateLimitConfigurations()).connectionRateLimitConfigurations(dataCloudConnection.getConnectionModel().getRateLimitConfigurationModels()).build();
        OperationResult result = ExecutionUtils.execute(this.connectorName, executionFunction, executionParameters, dataCloudConnection, this.retryConfiguration, rateLimitingConfiguration, this.rateLimitingPolicy);
        return this.processResult(executionStep, dataCloudConnection, executionParameters, result, fieldList, consumer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Serializable> processResult(int executionStep, DataCloudConnection dataCloudConnection, ExecutionParameters executionParameters, OperationResult<?> result, List<String> fieldList, Consumer<ConnectivityMessage> consumer) {
        if (!result.isSuccess()) {
            ResultError errorValue2 = result.getErrorValue();
            log.error("Unsuccessful execution Error: {}{}Cause: {}", new Object[]{errorValue2.getValue(), System.lineSeparator(), errorValue2.getDescription()});
            throw new RuntimeException("Operation execution returned with error: " + String.valueOf(errorValue2.getValue()) + System.lineSeparator() + "Cause: " + errorValue2.getDescription().orElse("Unknown") + System.lineSeparator());
        }
        Object value = result.orElseThrow(errorValue -> new RuntimeException("Failed to extract the result of the operation: " + String.valueOf(errorValue.getValue()) + System.lineSeparator() + "Cause: " + errorValue.getDescription().orElse("Unknown") + System.lineSeparator()));
        try {
            Object triggerPage;
            Object object;
            Page page;
            OperationsIndex.OperationWrapper current;
            block20: {
                AutoCloseable resource = (AutoCloseable)value;
                current = this.operations.get(executionStep);
                if (resource instanceof Page) {
                    page = (Page)resource;
                    log.info("Records present in current page: {}", (Object)page.getItems().size());
                    object = page.getItems().iterator();
                    break block20;
                } else {
                    Object content = ((Content)resource).get();
                    this.processItem(executionStep, content, fieldList, consumer, UnaryOperator.identity());
                    this.executeNextStep(executionStep, dataCloudConnection, current, executionParameters, content, fieldList, consumer);
                    Optional<Serializable> optional = Optional.empty();
                    return optional;
                }
                finally {
                    if (resource != null) {
                        resource.close();
                    }
                }
            }
            while (object.hasNext()) {
                boolean isContainer;
                Object item = object.next();
                boolean bl = isContainer = current.isContainer() != null && (Boolean)current.isContainer().apply(List.of(item)) != false;
                if (isContainer && current.containerBinding() != null) {
                    Map newParameters = (Map)current.containerBinding().apply(List.of(item));
                    this.execute(executionStep, dataCloudConnection, newParameters, executionParameters.getIncrementalAttributes(), fieldList, consumer);
                }
                if (!isContainer || current.doProcessContainer()) {
                    this.processItem(executionStep, item, fieldList, consumer, messageBuilder -> {
                        if (page instanceof TriggerPage) {
                            TriggerPage triggerPage = (TriggerPage)page;
                            messageBuilder.watermark(triggerPage.getNextPoll().getGreatestWatermark());
                        }
                        return messageBuilder;
                    });
                }
                this.executeNextStep(executionStep, dataCloudConnection, current, executionParameters, item, fieldList, consumer);
            }
            if (this.isLastPage(page)) {
                object = Optional.empty();
                return object;
            }
            if (page instanceof TriggerPage) {
                triggerPage = (TriggerPage)page;
                Optional<NextData> optional = Optional.of(triggerPage.getNextData());
                return optional;
            }
            triggerPage = page.getNextPage();
            return triggerPage;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process result content", e);
        }
    }

    private void executeNextStep(int executionStep, DataCloudConnection dataCloudConnection, OperationsIndex.OperationWrapper current, ExecutionParameters executionParameters, Object item, List<String> fieldList, Consumer<ConnectivityMessage> consumer) {
        if (executionStep < this.operations.size() - 1) {
            Map newParameters = (Map)current.dependencyBinding().apply(List.of(item));
            HashMap<String, Object> params = new HashMap<String, Object>((Map)executionParameters.getParameters());
            params.putAll(newParameters);
            this.execute(executionStep + 1, dataCloudConnection, params, executionParameters.getIncrementalAttributes(), fieldList, consumer);
        }
    }

    private void processItem(int executionStep, Object item, List<String> fieldList, Consumer<ConnectivityMessage> consumer, UnaryOperator<ConnectivityMessage.ConnectivityMessageBuilder> watermarkSetter) {
        Object object;
        OperationsIndex.OperationWrapper current = this.operations.get(executionStep);
        if (item instanceof TriggerItem) {
            TriggerItem triggerItem = (TriggerItem)item;
            object = triggerItem.getValue();
        } else {
            object = item;
        }
        Object data = object;
        String flattenSeparator = ExecutionContext.getGateValue(FeatureGates.FLATTEN_WITH_UNDERSCORES_ENABLED) ? "_" : ".";
        boolean processArrayAsTextEnabled = ExecutionContext.getGateValue(FeatureGates.PROCESS_ARRAY_AS_TEXT_ENABLED);
        this.objectFlattener.flattenObject(data, fieldList, flattenSeparator, processArrayAsTextEnabled).forEach(i -> {
            ConnectivityMessage.ConnectivityMessageBuilder messageBuilder = ConnectivityMessage.builder().type("application/json").content(i).type(current.objectName());
            messageBuilder = (ConnectivityMessage.ConnectivityMessageBuilder)watermarkSetter.apply(messageBuilder);
            consumer.accept(messageBuilder.build());
        });
    }

    private boolean isLastPage(Page<?> page) {
        return page.getNextPage().isEmpty();
    }
}

