/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.utils;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.ZonedDateTimeSerializer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectFlattener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ObjectFlattener.class);
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private static final String DEFAULT_DATE_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private final ObjectMapper objectMapper;

    public ObjectFlattener(@Nullable Map<String, String> dateFormats) {
        this.objectMapper = this.createObjectMapper(dateFormats);
    }

    public List<Map<String, Object>> flattenObject(Object item, List<String> fieldList, String separator, boolean processArrayAsText) {
        ArrayList<Map<String, Object>> flattenedList = new ArrayList<Map<String, Object>>();
        try {
            Map map = (Map)this.objectMapper.convertValue(item, Map.class);
            ObjectFlattener.flatten(map, new LinkedHashMap<String, Object>(), null, flattenedList, fieldList, separator, processArrayAsText, this.objectMapper);
        }
        catch (IllegalArgumentException e) {
            log.error("Error flattening object: {}", (Object)e.getMessage());
        }
        return flattenedList;
    }

    private ObjectMapper createObjectMapper(@Nullable Map<String, String> dateFormats) {
        String datePattern = dateFormats != null ? dateFormats.getOrDefault("date", DEFAULT_DATE_PATTERN) : DEFAULT_DATE_PATTERN;
        String dateTimePattern = dateFormats != null ? dateFormats.getOrDefault("date-time", DEFAULT_DATE_TIME_PATTERN) : DEFAULT_DATE_TIME_PATTERN;
        String localDateTimePattern = ObjectFlattener.stripTimezoneFromPattern(dateTimePattern);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern(datePattern)));
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern(localDateTimePattern)));
        javaTimeModule.addSerializer(ZonedDateTime.class, (JsonSerializer)new ZonedDateTimeSerializer(DateTimeFormatter.ofPattern(dateTimePattern)));
        return ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)javaTimeModule)).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).build();
    }

    private static String stripTimezoneFromPattern(String pattern) {
        return pattern.replaceAll("[XxZz]+", "").trim();
    }

    private static void flatten(Map<String, Object> map, Map<String, Object> currentFlattened, @Nullable String parentKey, List<Map<String, Object>> flattenedList, List<String> fieldList, String separator, boolean processArrayAsText, ObjectMapper objectMapper) {
        List<Map<String, Object>> newRecords = new ArrayList<Map<String, Object>>();
        newRecords.add(currentFlattened);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = (String)(parentKey != null ? parentKey + separator : "") + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                newRecords = ObjectFlattener.flattenMapItems(newRecords, (Map)value, key, fieldList, separator, processArrayAsText, objectMapper);
                continue;
            }
            if (value instanceof List) {
                if (processArrayAsText) {
                    newRecords = ObjectFlattener.flattenListItemAsText((List)value, newRecords, key, objectMapper);
                    continue;
                }
                newRecords = ObjectFlattener.flattenListItems((List)value, newRecords, key, fieldList, separator, processArrayAsText, objectMapper);
                continue;
            }
            for (Map map2 : newRecords) {
                if (!fieldList.contains(key)) continue;
                map2.put(key, value);
            }
        }
        flattenedList.addAll(newRecords);
    }

    private static List<Map<String, Object>> flattenListItems(List<?> items, List<Map<String, Object>> records, String key, List<String> fieldList, String separator, boolean processArrayAsText, ObjectMapper objectMapper) {
        ArrayList<Map<String, Object>> flattenedChildren = new ArrayList<Map<String, Object>>();
        if (!items.isEmpty()) {
            for (Object listItem : items) {
                for (Map<String, Object> recordItem : records) {
                    LinkedHashMap<String, Object> newRecord = new LinkedHashMap<String, Object>(recordItem);
                    if (listItem instanceof Map) {
                        ObjectFlattener.flatten((Map)listItem, newRecord, key, flattenedChildren, fieldList, separator, processArrayAsText, objectMapper);
                        continue;
                    }
                    if (fieldList.contains(key)) {
                        newRecord.put(key, listItem);
                    }
                    flattenedChildren.add(newRecord);
                }
            }
        } else {
            for (Map<String, Object> recordItem : records) {
                LinkedHashMap<String, Object> newRecord = new LinkedHashMap<String, Object>(recordItem);
                if (fieldList.contains(key)) {
                    newRecord.put(key, null);
                }
                flattenedChildren.add(newRecord);
            }
        }
        return flattenedChildren;
    }

    private static List<Map<String, Object>> flattenListItemAsText(List<?> items, List<Map<String, Object>> records, String key, ObjectMapper objectMapper) {
        ArrayList<Map<String, Object>> flattenedChildren = new ArrayList<Map<String, Object>>();
        if (!items.isEmpty()) {
            for (Map<String, Object> recordItem : records) {
                LinkedHashMap<String, Object> newRecord = new LinkedHashMap<String, Object>(recordItem);
                newRecord.put(key, objectMapper.writeValueAsString(items));
                flattenedChildren.add(newRecord);
            }
        } else {
            for (Map<String, Object> recordItem : records) {
                LinkedHashMap<String, Object> newRecord = new LinkedHashMap<String, Object>(recordItem);
                newRecord.put(key, null);
                flattenedChildren.add(newRecord);
            }
        }
        return flattenedChildren;
    }

    private static List<Map<String, Object>> flattenMapItems(List<Map<String, Object>> records, Map<String, Object> value, String key, List<String> fieldList, String separator, boolean processArrayAsText, ObjectMapper objectMapper) {
        ArrayList<Map<String, Object>> flattenedChildren = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> recordItem : records) {
            LinkedHashMap<String, Object> newRecord = new LinkedHashMap<String, Object>(recordItem);
            ObjectFlattener.flatten(value, newRecord, key, flattenedChildren, fieldList, separator, processArrayAsText, objectMapper);
        }
        return flattenedChildren;
    }
}

