/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.retry;

import com.mulesoft.connectivity.datacloud.internal.ratelimiter.RateLimitHeaders;
import com.mulesoft.connectivity.datacloud.internal.retry.ExponentialBackoffRetryStrategy;
import com.mulesoft.connectivity.datacloud.internal.retry.jitter.JitterStrategy;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottlingRetryStrategy
extends ExponentialBackoffRetryStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThrottlingRetryStrategy.class);

    public ThrottlingRetryStrategy(int maxAttempts, long baseDelayMillis, long maxDelayMillis, JitterStrategy jitterStrategy) {
        super(Set.of("THROTTLING", "RETRY"), maxAttempts, baseDelayMillis, maxDelayMillis, jitterStrategy);
    }

    @Override
    public long getDelayMillis(OperationResult<?> result, int attemptNumber) {
        long baseDelay = super.getBaseDelay(attemptNumber);
        RateLimitHeaders rateLimitHeaders = ThrottlingRetryStrategy.extractRateLimitHeaders(result);
        if (rateLimitHeaders != null && rateLimitHeaders.hasRetryAfter()) {
            baseDelay = rateLimitHeaders.getRetryDelayMillis();
            log.debug("Using server-provided retry delay: {} ms", (Object)baseDelay);
        }
        if (this.jitterStrategy != null) {
            baseDelay = this.jitterStrategy.getDelayMillis(baseDelay);
        }
        log.debug("Using backoff delay: {} ms (attempt {})", (Object)baseDelay, (Object)attemptNumber);
        return Math.max(baseDelay, 0L);
    }

    private static <T> @Nullable RateLimitHeaders extractRateLimitHeaders(OperationResult<T> result) {
        Object errorValue = result.getErrorValue().getValue();
        if (errorValue instanceof Map) {
            Map errorMap = (Map)errorValue;
            return RateLimitHeaders.from(errorMap);
        }
        return null;
    }
}

