/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.operation;

import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectorModel;
import com.mulesoft.connectivity.datacloud.internal.ConnectivityMessage;
import com.mulesoft.connectivity.datacloud.internal.connection.DataCloudConnection;
import com.mulesoft.connectivity.datacloud.internal.operation.DataCloudParameters;
import com.mulesoft.connectivity.datacloud.internal.operation.DataIterator;
import com.mulesoft.connectivity.datacloud.internal.operation.OperationsIndex;
import com.mulesoft.connectivity.datacloud.internal.ratelimiter.RateLimitingPolicy;
import com.mulesoft.connectivity.datacloud.internal.retry.RetryConfiguration;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.salesforce.dataconnectors.api.dataproviders.CloseableIterator;
import com.salesforce.dataconnectors.api.dataproviders.RecordProvider;
import com.salesforce.dataconnectors.api.exception.ConnectorException;
import com.salesforce.dataconnectors.api.exception.ExceptionCategory;
import com.salesforce.dataconnectors.api.model.data.Record;
import com.salesforce.dataconnectors.api.model.input.InputAttributes;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class RecordIterator
extends DataIterator<ConnectivityMessage>
implements RecordProvider {
    private @Nullable Object watermark;

    public RecordIterator(ModelInterpreter modelInterpreter, DataCloudConnectorModel connectorModel, InputAttributes inputAttributes, String objectName, DataCloudConnectionModel connectionModel, RetryConfiguration retryConfiguration, RateLimitingPolicy rateLimitingPolicy) {
        super(modelInterpreter, connectorModel, objectName, inputAttributes, connectionModel, retryConfiguration, rateLimitingPolicy);
    }

    @Override
    void doExtract() {
        OperationsIndex operationsIndex = new OperationsIndex(this.modelInterpreter, this.connectorModel, this.inputAttributes.getExtractAttributes(), this.retryConfiguration, this.rateLimitingPolicy);
        operationsIndex.getCollectionProvider(this.objectName).execute(new DataCloudConnection(this.connectionModel, this.inputAttributes), new DataCloudParameters(this.inputAttributes), this::consumeMessage);
    }

    private void consumeMessage(ConnectivityMessage message) {
        if (message.getType().equals(this.objectName)) {
            this.consumeData(message);
        }
    }

    public CloseableIterator<Record> get() {
        return new CloseableIterator<Record>(){

            public boolean hasNext() throws ConnectorException {
                return RecordIterator.this.hasMoreData(300L);
            }

            public Record next() throws ConnectorException {
                if (!this.hasNext()) {
                    throw new ConnectorException((Throwable)new NoSuchElementException("There's no next element!"), ExceptionCategory.INTERNAL);
                }
                ConnectivityMessage message = (ConnectivityMessage)RecordIterator.this.nextData();
                Object record = message.getContent();
                RecordIterator.this.watermark = message.getWatermark();
                return Record.builder().row((Map)record).build();
            }

            public void close() {
                RecordIterator.this.cancel();
            }
        };
    }

    public Map<String, Object> getIncrementalExtractAttributes() {
        return Objects.isNull(this.watermark) ? Collections.emptyMap() : Map.of("greatestWatermark", this.watermark);
    }
}

