%dw 2.8
import * from com::mulesoft::connectivity::datacloud::Metadata
import * from connectors::basicconnector::Module
import * from com::mulesoft::connectivity::transport::Serialization
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::Model

type MedicalRecordContent = {
    id: String,
    fileType: String,
    uri: String
}

type AdditionalOperationTypes = {
  "/medicalrecordContent": {
    get: {
      request: HttpRequestType<{|
        query: {
          limit?: Number
        },
        headers: Object,
        cookie: Object
      |}>,
      response: HttpResponse<AdditionalOperationTypes."/medicalrecordContent".get."200"> | HttpResponse<AdditionalOperationTypes."/medicalrecordContent".get."206">,
      "200": Array<MedicalRecordContent>,
      "206": MedicalRecordContent,
      "default": Types.Error
    }
  }
}

var medicalRecordContent = {
   name: "findMedicalRecords",
   displayName: "findMedicalRecords",
   executor: (parameter: AdditionalOperationTypes."/medicalrecordContent".get.request, connection: HttpConnection): Result<AdditionalOperationTypes."/medicalrecordContent".get.response, ResultFailure<HttpResponse<AdditionalOperationTypes."/medicalrecordContent".get."default">,Error>> -> do {
     var query = parameter.query default {} withSerializationConfig {}
     var headers = serializeHeaders(parameter.headers default {}, {})
     var cookie = serializeCookies(parameter.cookie default {}, {})
     ---
     success(connection({
       method: "GET",
       path: "/medicalrecordContent",
       queryParams: query,
       headers: headers,
       cookie: cookie,
       (body: parameter.body) if (parameter.body?)
     }) as AdditionalOperationTypes."/medicalrecordContent".get.response)
   }
}

var medicalRecord = {
    name: "MedicalRecord",
    resolvedBy: medicalRecordContent
}

@DataCloudConnectorElement()
var connector = {
  name: "Variant Connector",
  label: "Label for the Variant Connector",
  description: "Description for the Variant Connector",
  displayName: "Variant Connector",
  releaseLevel: "IN_DEV",
  features: ["INGRESS","OBJECTBASED"],
  connection:  connectionProvider,
  testConnection: testConnection,
  version: "0.0.1",
  ingressDescription: "Variant Connector",
  vendor: "Mulesoft",
  objects: {
    medicalRecord: medicalRecord
  }
}
