/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.api.loader;

import com.mulesoft.connectivity.datacloud.api.loader.DataCloudModelLoaderFactory;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionProviderModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectorModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudObjectModel;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ModuleComponentsFactory;
import org.mule.weave.v2.runtime.SimpleModuleComponentFactory;

class DataCloudConnectorLoaderTest {
    public static final String TWILIO_CONNECTOR_REFERENCE = "connectors::twilio::Connector::connector";
    public static final String DEMO_CONNECTOR_REFERENCE = "connectors::demo::Connector::connector";
    public static final String BASIC_CONNECTOR_REFERENCE = "connectors::basicconnector::Connector::connector";
    public static final String TRIGGERS_CONNECTOR_REFERENCE = "connectors::triggers::Connector::connector";
    public static final String WEATHER_CONNECTOR_REFERENCE = "connectors::weather::Connector::connector";

    DataCloudConnectorLoaderTest() {
    }

    @Test
    void describeDemoConnectorTest() {
        DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::flow::Metadata::DataCloudConnectorElement"));
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)modelLoader.loadConnector(DEMO_CONNECTOR_REFERENCE);
        MatcherAssert.assertThat((Object)connectorModel.getName(), (Matcher)Matchers.equalTo((Object)"Demo Connector"));
        MatcherAssert.assertThat((Object)connectorModel.getLabel(), (Matcher)Matchers.equalTo((Object)"Label for de Demo Connector"));
        MatcherAssert.assertThat((Object)connectorModel.getIngressDescription(), (Matcher)Matchers.equalTo((Object)"Ingress description for the Demo Connector"));
        MatcherAssert.assertThat((Object)connectorModel.getReleaseLevel().name(), (Matcher)Matchers.equalTo((Object)"IN_DEV"));
        MatcherAssert.assertThat((Object)connectorModel.getFeatures(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(connectorModel.getFeatures().stream().map(Enum::name).toList(), (Matcher)Matchers.contains((Object[])new String[]{"INGRESS", "OBJECTBASED"}));
        MatcherAssert.assertThat((Object)connectorModel.getVersion(), (Matcher)Matchers.equalTo((Object)"0.0.1"));
        MatcherAssert.assertThat((Object)connectorModel.getVendor(), (Matcher)Matchers.equalTo((Object)"Mulesoft"));
        MatcherAssert.assertThat((Object)connectorModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectorModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)DEMO_CONNECTOR_REFERENCE));
        MatcherAssert.assertThat((Object)connectorModel.getConnections(), (Matcher)Matchers.hasSize((int)1));
        DataCloudConnectionModel dataCloudConnectionModel = (DataCloudConnectionModel)connectorModel.getConnections().get(0);
        DataCloudConnectionProviderModel connectionModel = dataCloudConnectionModel.getConnectionProviderModel();
        MatcherAssert.assertThat((Object)connectionModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectionModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"connectors::demo::Connector::connector.connection"));
        TestConnectionModel testConnection = connectorModel.getTestConnection();
        MatcherAssert.assertThat((Object)testConnection, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)testConnection.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)testConnection.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"connectors::demo::Connector::connector.testConnection"));
        MatcherAssert.assertThat((Object)connectorModel.getObjects().isEmpty(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Pet")), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Pet")).getName(), (Matcher)Matchers.equalTo((Object)"Pet"));
        ObjectType pet = (ObjectType)((DataCloudObjectModel)connectorModel.getObjects().get("Pet")).getMetadataType().getDataType();
        Map<Object, Object> fields = Arrays.stream(pet.getProperties()).collect(Collectors.toMap(DWTypeUtils::getKey, KeyValuePairType::getValue));
        MatcherAssert.assertThat(fields.entrySet(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)fields.get("name"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(StringType.class)));
        MatcherAssert.assertThat((Object)fields.get("tag"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(StringType.class)));
        MatcherAssert.assertThat((Object)fields.get("id"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(NumberType.class)));
    }

    @Test
    void describeTwilioConnectorTest() {
        DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::flow::Metadata::DataCloudConnectorElement"));
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)modelLoader.loadConnector(TWILIO_CONNECTOR_REFERENCE);
        MatcherAssert.assertThat((Object)connectorModel.getName(), (Matcher)Matchers.equalTo((Object)"Twilio Connector"));
        MatcherAssert.assertThat((Object)connectorModel.getLabel(), (Matcher)Matchers.equalTo((Object)"Twilio Connector"));
        MatcherAssert.assertThat((Object)connectorModel.getIngressDescription(), (Matcher)Matchers.equalTo((Object)"Twilio Connector"));
        MatcherAssert.assertThat((Object)connectorModel.getReleaseLevel().name(), (Matcher)Matchers.equalTo((Object)"IN_DEV"));
        MatcherAssert.assertThat((Object)connectorModel.getFeatures(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(connectorModel.getFeatures().stream().map(Enum::name).toList(), (Matcher)Matchers.contains((Object[])new String[]{"INGRESS", "OBJECTBASED"}));
        MatcherAssert.assertThat((Object)connectorModel.getVersion(), (Matcher)Matchers.equalTo((Object)"0.0.1"));
        MatcherAssert.assertThat((Object)connectorModel.getVendor(), (Matcher)Matchers.equalTo((Object)"Mulesoft"));
        MatcherAssert.assertThat((Object)connectorModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectorModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)TWILIO_CONNECTOR_REFERENCE));
        MatcherAssert.assertThat((Object)connectorModel.getConnections(), (Matcher)Matchers.hasSize((int)1));
        DataCloudConnectionModel dataCloudConnectionModel = (DataCloudConnectionModel)connectorModel.getConnections().get(0);
        DataCloudConnectionProviderModel connectionModel = dataCloudConnectionModel.getConnectionProviderModel();
        MatcherAssert.assertThat((Object)connectionModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectionModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"connectors::twilio::Connector::connector.connection"));
        TestConnectionModel testConnection = connectorModel.getTestConnection();
        MatcherAssert.assertThat((Object)testConnection, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)testConnection.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)testConnection.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"connectors::twilio::Connector::connector.testConnection"));
        MatcherAssert.assertThat((Object)connectorModel.getObjects().isEmpty(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Account")), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Account")).getName(), (Matcher)Matchers.equalTo((Object)"Account"));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Account")).getMetadataType(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        ObjectType account = (ObjectType)((DataCloudObjectModel)connectorModel.getObjects().get("Account")).getMetadataType().getDataType();
        Map<Object, Object> fields = Arrays.stream(account.getProperties()).collect(Collectors.toMap(DWTypeUtils::getKey, KeyValuePairType::getValue));
        MatcherAssert.assertThat(fields.entrySet(), (Matcher)Matchers.hasSize((int)10));
        MatcherAssert.assertThat((Object)fields.get("sid"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(StringType.class)));
        MatcherAssert.assertThat((Object)fields.get("friendly_name"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(StringType.class)));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Message")), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Message")).getName(), (Matcher)Matchers.equalTo((Object)"Message"));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Message")).getMetadataType(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        ObjectType message = (ObjectType)((DataCloudObjectModel)connectorModel.getObjects().get("Message")).getMetadataType().getDataType();
        fields = Arrays.stream(message.getProperties()).collect(Collectors.toMap(DWTypeUtils::getKey, KeyValuePairType::getValue));
        MatcherAssert.assertThat(fields.entrySet(), (Matcher)Matchers.hasSize((int)20));
        MatcherAssert.assertThat((Object)fields.get("sid"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(StringType.class)));
        MatcherAssert.assertThat((Object)fields.get("body"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(StringType.class)));
    }

    @Test
    void describeBasicConnectorTest() {
        DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::flow::Metadata::DataCloudConnectorElement"));
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)modelLoader.loadConnector(BASIC_CONNECTOR_REFERENCE);
        MatcherAssert.assertThat((Object)connectorModel.getName(), (Matcher)Matchers.equalTo((Object)"Basic Connector"));
        MatcherAssert.assertThat((Object)connectorModel.getLabel(), (Matcher)Matchers.equalTo((Object)"Label for the Basic Connector"));
        MatcherAssert.assertThat((Object)connectorModel.getDescription(), (Matcher)Matchers.equalTo((Object)"Description for the Basic Connector"));
        MatcherAssert.assertThat((Object)connectorModel.getIngressDescription(), (Matcher)Matchers.equalTo((Object)"Basic Connector"));
        MatcherAssert.assertThat((Object)connectorModel.getReleaseLevel().name(), (Matcher)Matchers.equalTo((Object)"IN_DEV"));
        MatcherAssert.assertThat((Object)connectorModel.getFeatures(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(connectorModel.getFeatures().stream().map(Enum::name).toList(), (Matcher)Matchers.contains((Object[])new String[]{"INGRESS", "OBJECTBASED"}));
        MatcherAssert.assertThat((Object)connectorModel.getVersion(), (Matcher)Matchers.equalTo((Object)"0.0.1"));
        MatcherAssert.assertThat((Object)connectorModel.getVendor(), (Matcher)Matchers.equalTo((Object)"Mulesoft"));
        MatcherAssert.assertThat((Object)connectorModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectorModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)BASIC_CONNECTOR_REFERENCE));
        MatcherAssert.assertThat((Object)connectorModel.getConnections(), (Matcher)Matchers.hasSize((int)1));
        DataCloudConnectionModel dataCloudConnectionModel = (DataCloudConnectionModel)connectorModel.getConnections().get(0);
        DataCloudConnectionProviderModel connectionModel = dataCloudConnectionModel.getConnectionProviderModel();
        MatcherAssert.assertThat((Object)connectionModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectionModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"connectors::basicconnector::Connector::connector.connection"));
        TestConnectionModel testConnection = connectorModel.getTestConnection();
        MatcherAssert.assertThat((Object)testConnection, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)testConnection.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)testConnection.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"connectors::basicconnector::Connector::connector.testConnection"));
        MatcherAssert.assertThat((Object)connectorModel.getObjects().isEmpty(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Accessory")), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Accessory")).getName(), (Matcher)Matchers.equalTo((Object)"Accessory"));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Accessory")).getMetadataType(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        ObjectType account = (ObjectType)((DataCloudObjectModel)connectorModel.getObjects().get("Accessory")).getMetadataType().getDataType();
        Map<Object, Object> fields = Arrays.stream(account.getProperties()).collect(Collectors.toMap(DWTypeUtils::getKey, KeyValuePairType::getValue));
        MatcherAssert.assertThat(fields.entrySet(), (Matcher)Matchers.hasSize((int)5));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("MedicalRecord")), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("MedicalRecord")).getName(), (Matcher)Matchers.equalTo((Object)"MedicalRecord"));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("MedicalRecord")).getMetadataType(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        ObjectType message = (ObjectType)((DataCloudObjectModel)connectorModel.getObjects().get("MedicalRecord")).getMetadataType().getDataType();
        fields = Arrays.stream(message.getProperties()).collect(Collectors.toMap(DWTypeUtils::getKey, KeyValuePairType::getValue));
        MatcherAssert.assertThat(fields.entrySet(), (Matcher)Matchers.hasSize((int)5));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Pet")), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Pet")).getName(), (Matcher)Matchers.equalTo((Object)"Pet"));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Pet")).getMetadataType(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        ObjectType pet = (ObjectType)((DataCloudObjectModel)connectorModel.getObjects().get("Pet")).getMetadataType().getDataType();
        fields = Arrays.stream(pet.getProperties()).collect(Collectors.toMap(DWTypeUtils::getKey, KeyValuePairType::getValue));
        MatcherAssert.assertThat(fields.entrySet(), (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    void describeTriggerConnectorTest() {
        DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::flow::Metadata::DataCloudConnectorElement"));
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)modelLoader.loadConnector(TRIGGERS_CONNECTOR_REFERENCE);
        MatcherAssert.assertThat((Object)connectorModel.getName(), (Matcher)Matchers.equalTo((Object)"Triggers Connector"));
        MatcherAssert.assertThat((Object)connectorModel.getLabel(), (Matcher)Matchers.equalTo((Object)"Label for the Triggers Connector"));
        MatcherAssert.assertThat((Object)connectorModel.getDescription(), (Matcher)Matchers.equalTo((Object)"Description for the Triggers Connector"));
        MatcherAssert.assertThat((Object)connectorModel.getIngressDescription(), (Matcher)Matchers.equalTo((Object)"Ingress description for Triggers Connector"));
        MatcherAssert.assertThat((Object)connectorModel.getReleaseLevel().name(), (Matcher)Matchers.equalTo((Object)"IN_DEV"));
        MatcherAssert.assertThat((Object)connectorModel.getFeatures(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(connectorModel.getFeatures().stream().map(Enum::name).toList(), (Matcher)Matchers.contains((Object[])new String[]{"INGRESS", "OBJECTBASED"}));
        MatcherAssert.assertThat((Object)connectorModel.getVersion(), (Matcher)Matchers.equalTo((Object)"0.0.1"));
        MatcherAssert.assertThat((Object)connectorModel.getVendor(), (Matcher)Matchers.equalTo((Object)"Mulesoft"));
        MatcherAssert.assertThat((Object)connectorModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectorModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)TRIGGERS_CONNECTOR_REFERENCE));
        MatcherAssert.assertThat((Object)connectorModel.getConnections(), (Matcher)Matchers.hasSize((int)1));
        DataCloudConnectionModel dataCloudConnectionModel = (DataCloudConnectionModel)connectorModel.getConnections().get(0);
        DataCloudConnectionProviderModel connectionModel = dataCloudConnectionModel.getConnectionProviderModel();
        MatcherAssert.assertThat((Object)connectionModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectionModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"connectors::triggers::Connector::connector.connection"));
        TestConnectionModel testConnection = connectorModel.getTestConnection();
        MatcherAssert.assertThat((Object)testConnection, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)testConnection.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)testConnection.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"connectors::triggers::Connector::connector.testConnection"));
        MatcherAssert.assertThat((Object)connectorModel.getObjects().isEmpty(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Songs")), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Songs")).getName(), (Matcher)Matchers.equalTo((Object)"Songs"));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Songs")).getMetadataType(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        ObjectType account = (ObjectType)((DataCloudObjectModel)connectorModel.getObjects().get("Songs")).getMetadataType().getDataType();
        Map<Object, Object> fields = Arrays.stream(account.getProperties()).collect(Collectors.toMap(DWTypeUtils::getKey, KeyValuePairType::getValue));
        MatcherAssert.assertThat(fields.entrySet(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    void describeWeatherConnectorTest() {
        DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::flow::Metadata::DataCloudConnectorElement"));
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)modelLoader.loadConnector(WEATHER_CONNECTOR_REFERENCE);
        MatcherAssert.assertThat((Object)connectorModel.getName(), (Matcher)Matchers.equalTo((Object)"WeatherServiceConnector"));
        MatcherAssert.assertThat((Object)connectorModel.getLabel(), (Matcher)Matchers.equalTo((Object)"Weather Service Connector"));
        MatcherAssert.assertThat((Object)connectorModel.getDescription(), (Matcher)Matchers.equalTo((Object)"A connector for accessing weather information and forecasts"));
        MatcherAssert.assertThat((Object)connectorModel.getIngressDescription(), (Matcher)Matchers.equalTo((Object)"Weather Service Connector"));
        MatcherAssert.assertThat((Object)connectorModel.getReleaseLevel().name(), (Matcher)Matchers.equalTo((Object)"IN_DEV"));
        MatcherAssert.assertThat((Object)connectorModel.getFeatures(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(connectorModel.getFeatures().stream().map(Enum::name).toList(), (Matcher)Matchers.contains((Object[])new String[]{"INGRESS", "FILEBASED"}));
        MatcherAssert.assertThat((Object)connectorModel.getVersion(), (Matcher)Matchers.equalTo((Object)"0.0.1"));
        MatcherAssert.assertThat((Object)connectorModel.getVendor(), (Matcher)Matchers.equalTo((Object)"Mulesoft"));
        MatcherAssert.assertThat((Object)connectorModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectorModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)WEATHER_CONNECTOR_REFERENCE));
        MatcherAssert.assertThat((Object)connectorModel.getConnections(), (Matcher)Matchers.hasSize((int)3));
        DataCloudConnectionModel connectionModel = (DataCloudConnectionModel)connectorModel.getConnections().get(0);
        MatcherAssert.assertThat((Object)connectionModel.getName(), (Matcher)Matchers.equalTo((Object)"basicAuth"));
        MatcherAssert.assertThat((Object)connectionModel.getConnectionProviderModel().getTestConnection(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        connectionModel = (DataCloudConnectionModel)connectorModel.getConnections().get(1);
        MatcherAssert.assertThat((Object)connectionModel.getName(), (Matcher)Matchers.equalTo((Object)"restApiAuth"));
        MatcherAssert.assertThat((Object)connectionModel.getConnectionProviderModel().getTestConnection(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        connectionModel = (DataCloudConnectionModel)connectorModel.getConnections().get(2);
        MatcherAssert.assertThat((Object)connectionModel.getName(), (Matcher)Matchers.equalTo((Object)"graphApiAuth"));
        MatcherAssert.assertThat((Object)connectionModel.getConnectionProviderModel().getTestConnection(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)connectorModel.getObjects().isEmpty(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("CurrentWeather")), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("CurrentWeather")).getName(), (Matcher)Matchers.equalTo((Object)"CurrentWeather"));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Forecast")), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Forecast")).getName(), (Matcher)Matchers.equalTo((Object)"Forecast"));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Alert")), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Alert")).getName(), (Matcher)Matchers.equalTo((Object)"Alert"));
    }
}

