%dw 2.7
import * from com::mulesoft::connectivity::datacloud::Metadata
import * from connectors::ratelimits::Module

var userRateLimiter = {
    idProvider: {
        inputSelectors: [
            {
                key: "clientId"
            },
            {
                key: "refreshToken",
                secured: true
            }
        ]
    },
    rate: {
        value: 500,
        interval: 1,
        intervalUnit: "HOURS"
    }
}

var cityAndRegionRateLimiter = {
    idProvider: {
        inputSelectors: [{
            key: "city"
        }],
        additionalKeyValues: {
            regionId: "uswest"
        }
    },
    enabled: true,
    tenantScoped: false,
    rate: {
        value: 10000,
        interval: 60,
        intervalUnit: "MINUTES"
    },
    request: {
        permits: 2,
        timeout: 60,
        timeoutUnit: "MINUTES"
    }
}

@DataCloudConnectorElement()
var connector = {
  name: "Weather Station Connector",
  label: "Weather Station Monitoring System",
  description: "Connector for accessing weather station data and monitoring systems",
  displayName: "Weather Station Connector",
  releaseLevel: "IN_DEV",
  features: ["INGRESS","OBJECTBASED"],
  connection: {
    provider: connectionProviders.oauth2,
    rateLimiterConfigs: {
        user: userRateLimiter,
        cityAndRegion: cityAndRegionRateLimiter
    }
  },
  testConnection: testConnection,
  version: "0.0.1",
  ingressDescription: "Weather Station Connector",
  vendor: "Mulesoft",
  objects: {
      station: {
        name: "WeatherStation",
        resolvedBy: mappedOperations.stations ++ {
            rateLimiterConfigs: {
                stationRateLimit: {
                    rate: {
                        value: 1000,
                        interval: 5000,
                        intervalUnit: "SECONDS"
                    }
                }
            }
        }
      },
      measurement: {
        name: "Measurement",
        resolvedBy: mappedOperations.measurements ++ {
            rateLimiterConfigs: {
                measurementRateLimit: {
                    rate: {
                        value: 500,
                        interval: 1,
                        intervalUnit: "MINUTES"
                    }
                }
            }
        }
      },
      alert: {
        name: "Alert",
        resolvedBy: mappedOperations.alerts ++ {
            rateLimiterConfigs: {
                alertRateLimit: {
                    rate: {
                        value: 2000,
                        interval: 1,
                        intervalUnit: "HOURS"
                    }
                }
            }
        },
        contentProvider: mappedOperations.alertSummary ++ {
            rateLimiterConfigs: {
                alertProviderRateLimit: {
                    rate: {
                        value: 500,
                        interval: 2,
                        intervalUnit: "HOURS"
                    }
                }
            }
        }
      }
    }
} 
