/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.api.loader;

import com.mulesoft.connectivity.datacloud.api.loader.DataCloudConnectionLoader;
import com.mulesoft.connectivity.datacloud.api.loader.DataCloudObjectsLoader;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectorModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudObjectModel;
import com.mulesoft.connectivity.datacloud.api.model.RateLimitConfigurationModel;
import com.mulesoft.connectivity.linkweave.api.DataWeaveObjectReference;
import com.mulesoft.connectivity.linkweave.api.DataWeaveReference;
import com.mulesoft.connectivity.linkweave.api.loader.ConnectorLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.impl.TestConnectionLoaderImpl;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public class DataCloudConnectorLoader
extends ConnectorLoader<DataCloudConnectorModel, DataCloudConnectorModel.Builder, DataWeaveObjectReference> {
    private final ModelLoader<TestConnectionModel, TestConnectionModel.Builder, DataWeaveObjectReference> testConnectionLoader;
    private final DataCloudConnectionLoader connectionLoader;
    private final DataCloudObjectsLoader objectsLoader;

    public DataCloudConnectorLoader(DataCloudConnectionLoader connectionLoader, TestConnectionLoaderImpl testConnectionLoader, DataCloudObjectsLoader objectsLoader) {
        this.connectionLoader = connectionLoader;
        this.testConnectionLoader = testConnectionLoader;
        this.objectsLoader = objectsLoader;
    }

    protected DataCloudConnectorModel.Builder createBuilder() {
        return new DataCloudConnectorModel.Builder();
    }

    protected DataCloudConnectorModel.Builder configureBuilder(DataCloudConnectorModel.Builder builder, DataWeaveObjectReference connectorObject, @Nullable String name) {
        builder.withName(connectorObject.requireProperty("name").asString()).withLabel(connectorObject.requireProperty("label").asString()).withDescription(connectorObject.getProperty("description").map(DataWeaveReference::asString).orElse(null)).withVendor(connectorObject.requireProperty("vendor").asString()).withVersion(connectorObject.requireProperty("version").asString()).withIngressDescription(connectorObject.requireProperty("ingressDescription").asString()).withEgressDescription(connectorObject.getProperty("egressDescription").map(DataWeaveReference::asString).orElse(null)).withReleaseLevel(connectorObject.requireProperty("releaseLevel").asString()).withAccessCheck(connectorObject.getProperty("accessCheck").map(DataWeaveReference::asString).orElse(null)).withFeatures((List)connectorObject.requireProperty("features").getValue()).withModelReference(connectorObject.getPath());
        connectorObject.getProperty("featuresConfig").map(DataWeaveReference::asObjectReference).ifPresent(featuresConfigRef -> builder.withFeatureConfigs(featuresConfigRef.properties().collect(Collectors.toMap(Map.Entry::getKey, f -> ((DataWeaveReference)f.getValue()).asObjectReference().properties().collect(Collectors.toMap(Map.Entry::getKey, c -> ((DataWeaveReference)c.getValue()).asString()))))));
        connectorObject.getProperty("customErrorLabels").map(DataWeaveReference::asObjectReference).ifPresent(customErrorsRef -> builder.withCustomErrorLabels((Map)customErrorsRef.getValue()));
        List connections = connectorObject.getObjectProperty("connections").map(connection -> connection.properties().map(p -> (DataCloudConnectionModel)this.connectionLoader.loadModel((DataWeaveReference)((DataWeaveReference)p.getValue()).asObjectReference(), (String)p.getKey())).toList()).orElseGet(() -> Collections.singletonList((DataCloudConnectionModel)this.connectionLoader.loadModel((DataWeaveReference)connectorObject.requireObjectProperty("connection"), "default-connection")));
        builder.withConnections(connections);
        connectorObject.getObjectProperty("testConnection").ifPresent(tc -> builder.withTestConnection((TestConnectionModel)this.testConnectionLoader.loadModel((DataWeaveReference)tc, null)));
        this.objectsLoader.setConnections(connections);
        builder.withObjects(connectorObject.requireObjectProperty("objects").properties().map(p -> (DataCloudObjectModel)this.objectsLoader.loadModel((DataWeaveReference)((DataWeaveReference)p.getValue()).asObjectReference(), null)).collect(Collectors.toMap(DataCloudObjectModel::getName, Function.identity())));
        connectorObject.getObjectProperty("externalCallout").ifPresent(externalCallout -> builder.withExternalCallout(externalCallout.properties().map(p -> (DataCloudObjectModel)this.objectsLoader.loadModel((DataWeaveReference)((DataWeaveReference)p.getValue()).asObjectReference(), null)).collect(Collectors.toMap(DataCloudObjectModel::getName, Function.identity()))));
        connectorObject.requireObjectProperty("objects").properties().map(p -> ((DataWeaveReference)p.getValue()).asObjectReference()).forEach(o -> o.getObjectProperty("dependsOn").ifPresent(d -> {
            String objectName = o.requireProperty("name").asString();
            String dependsOn = (String)((Map)d.requireObjectProperty("object").getValue()).get("name");
            builder.withDependencyOn(objectName, dependsOn);
        }));
        Map<String, RateLimitConfigurationModel> rateLimitConfigurationModels = this.connectionLoader.getRateLimitConfigurationModels();
        rateLimitConfigurationModels.putAll(this.objectsLoader.getRateLimitConfigurationModels());
        builder.withRateLimitConfigurationModels(rateLimitConfigurationModels);
        return builder;
    }
}

