%dw 2.8
import * from com::mulesoft::connectivity::datacloud::Metadata
import * from connectors::basicconnector::Module
import * from com::mulesoft::connectivity::transport::Serialization
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::Model

type AdditionalOperationTypes = {
  "/findAnything": {
    get: {
      request: HttpRequestType<{|
        query: Object,
        headers: Object,
        cookie: Object
      |}>,
      response: Array<Any> | Types.Error,
      "200": Array<Any>,
      "default": Types.Error
    }
  }
}

var findAnything = {
   name: "findAnything",
   displayName: "findAnything",
   executor: (parameter: AdditionalOperationTypes."/findAnything".get.request, connection: HttpConnection): Result<HttpResponse<AdditionalOperationTypes."/findAnything".get."200">, ResultFailure<HttpResponse<AdditionalOperationTypes."/findAnything".get."default">,Error>> -> do {
     var query = parameter.query default {} withSerializationConfig {}
     var headers = serializeHeaders(parameter.headers default {}, {})
     var cookie = serializeCookies(parameter.cookie default {}, {})
     ---
     success(connection({
       method: "GET",
       path: "/findAnything",
       queryParams: query,
       headers: headers,
       cookie: cookie,
       (body: parameter.body) if (parameter.body?)
     }) as HttpResponse<AdditionalOperationTypes."/findAnything".get."200">)
   }
}

var anything = {
    name: "Anything",
    resolvedBy: findAnything
}

@DataCloudConnectorElement()
var connector = {
  name: "Variant Connector",
  label: "Label for the Variant Connector",
  description: "Description for the Variant Connector",
  displayName: "Variant Connector",
  releaseLevel: "IN_DEV",
  features: ["INGRESS","OBJECTBASED"],
  connection:  connectionProvider,
  testConnection: testConnection,
  version: "0.0.1",
  ingressDescription: "Variant Connector",
  vendor: "Mulesoft",
  objects: {
    anything: anything
  }
}
