/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.api.utils;

import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectorModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudObjectModel;
import com.mulesoft.connectivity.linkweave.api.loader.WeaveTypeSimplifier;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataValueUtils;
import com.mulesoft.connectivity.linkweave.api.model.MetadataKey;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.salesforce.dataconnectors.api.model.connection.Attribute;
import com.salesforce.dataconnectors.api.model.connection.ConnectorFrameworkFeature;
import com.salesforce.dataconnectors.api.model.connection.ConnectorOption;
import com.salesforce.dataconnectors.api.model.connection.DataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.ArrayMetadataValue;
import org.mule.weave.v2.api.tooling.ts.DWMetadata;
import org.mule.weave.v2.api.tooling.ts.DWMetadataValue;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.LiteralMetadataValue;
import org.mule.weave.v2.api.tooling.ts.ObjectType;

public class DataCloudMetadataHelper {
    private static final Map<String, String> OBJECT_TYPE_LABELS = new HashMap<String, String>();

    private DataCloudMetadataHelper() {
        throw new IllegalStateException();
    }

    public static Optional<DWMetadataValue> getMetadataFromField(KeyValuePairType field, String metadataName) {
        List<String> metadataNames = List.of(metadataName, metadataName.toLowerCase());
        for (String name : metadataNames) {
            Optional keyMetadata = field.getKey().getTypeMetadata(name);
            if (keyMetadata.isPresent()) {
                return Optional.of(((DWMetadata)keyMetadata.get()).getValue());
            }
            Optional valueMetadata = field.getValue().getTypeMetadata(name);
            if (!valueMetadata.isPresent()) continue;
            return Optional.of(((DWMetadata)valueMetadata.get()).getValue());
        }
        return Optional.empty();
    }

    public static String getFieldLabel(KeyValuePairType field) {
        return DataCloudMetadataHelper.getMetadataFromField(field, MetadataKey.LABEL.getKey()).map(metadata -> MetadataValueUtils.asString((DWMetadataValue)metadata, (String)MetadataKey.LABEL.getKey())).orElse(field.getLabel().orElseGet(() -> DWTypeUtils.getKey((KeyValuePairType)field)));
    }

    public static @Nullable String getFieldHelpText(KeyValuePairType field) {
        return DataCloudMetadataHelper.getMetadataFromField(field, MetadataKey.HELP_TEXT.getKey()).map(metadata -> MetadataValueUtils.asString((DWMetadataValue)metadata, (String)MetadataKey.HELP_TEXT.getKey())).orElse(null);
    }

    public static boolean isFieldSecure(KeyValuePairType field) {
        return DataCloudMetadataHelper.getMetadataFromField(field, "Secure").isPresent() || DataCloudMetadataHelper.hasSemanticTerm(field, "password") || DataCloudMetadataHelper.hasSemanticTerm(field, "passwordFile") || DataCloudMetadataHelper.hasSemanticTerm(field, "secretToken");
    }

    public static boolean hasSemanticTerm(KeyValuePairType field, String semanticTerm) {
        return field.getValue().getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).map(f -> Arrays.stream(((ArrayMetadataValue)f.getValue()).getElements()).anyMatch(e -> ((LiteralMetadataValue)e).getValue().equalsIgnoreCase(semanticTerm))).orElse(false);
    }

    public static DataType dataTypeFromMetadataType(KeyValuePairType fieldType) {
        if (DataCloudMetadataHelper.hasSemanticTerm(fieldType, "password")) {
            return DataType.PASSWORD;
        }
        if (DataCloudMetadataHelper.hasSemanticTerm(fieldType, "passwordFile")) {
            return DataType.PASSWORDFILE;
        }
        return DataType.TEXT;
    }

    public static List<Attribute> getExtractAttributes(DataCloudConnectorModel connectorModel) {
        HashMap<String, Attribute> attributes = new HashMap<String, Attribute>();
        HashMap attributesByObjectType = new HashMap();
        Boolean isFileBased = connectorModel.getFeatures().contains(ConnectorFrameworkFeature.FILEBASED);
        connectorModel.getObjects().values().forEach(object -> {
            ObjectType inputType = DataCloudMetadataHelper.resolveInputObjectType(object);
            if (inputType != null) {
                Arrays.stream(inputType.getProperties()).forEach(property -> DataCloudMetadataHelper.getMetadataFromField(property, "DataCloudExtractAttribute").ifPresent(metadata -> {
                    String name = DWTypeUtils.getKey((KeyValuePairType)property);
                    attributes.putIfAbsent(name, Attribute.builder().label(((LiteralMetadataValue)metadata).getValue()).dataType(DataCloudMetadataHelper.dataTypeFromMetadataType(property)).required(Boolean.valueOf(!property.isOptionalKey())).name(name).build());
                }));
            }
            if (isFileBased.booleanValue() && object.getType() != null) {
                String objectTypeName = object.getType().name();
                Set<String> namesForObject = DataCloudMetadataHelper.collectAttributeNamesForObject(object, new HashSet<DataCloudObjectModel>());
                namesForObject.add("objectName");
                if (!namesForObject.isEmpty()) {
                    attributesByObjectType.computeIfAbsent(objectTypeName, key -> new LinkedHashSet()).addAll(namesForObject);
                }
            }
        });
        if (isFileBased.booleanValue()) {
            attributes.putIfAbsent("objectName", Attribute.builder().name("objectName").label("Access Control Object Name").type("custom").dataType(DataType.TEXT).required(Boolean.valueOf(true)).hidden(Boolean.valueOf(true)).editable(Boolean.valueOf(true)).build());
            List options = attributesByObjectType.entrySet().stream().map(entry -> ConnectorOption.builder().value((String)entry.getKey()).label(OBJECT_TYPE_LABELS.getOrDefault(entry.getKey(), (String)entry.getKey())).attributes(new ArrayList((Collection)entry.getValue())).build()).collect(Collectors.toList());
            if (!attributesByObjectType.isEmpty()) {
                Attribute objectTypeAttribute = Attribute.builder().name("objectType").label("Object Type").type("custom").dataType(DataType.RADIO).defaultValue("UNSTRUCTURED_DATA").required(Boolean.valueOf(true)).hidden(Boolean.valueOf(true)).options(options).build();
                attributes.put("objectType", objectTypeAttribute);
            }
        }
        return new ArrayList<Attribute>(attributes.values());
    }

    private static @Nullable ObjectType resolveInputObjectType(DataCloudObjectModel object) {
        DWType dataType = object.getResolvedBy().getInputType().getDataType();
        return (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)dataType);
    }

    private static Set<String> collectAttributeNamesForObject(DataCloudObjectModel object, Set<DataCloudObjectModel> visited) {
        DataCloudObjectModel dependency;
        if (object == null) {
            return Set.of();
        }
        if (visited.contains((Object)object)) {
            throw new IllegalStateException("Circular dependency detected in DataCloud objects at: " + object.getName());
        }
        visited.add(object);
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        ObjectType inputType = DataCloudMetadataHelper.resolveInputObjectType(object);
        if (inputType != null && inputType.getProperties() != null) {
            Arrays.stream(inputType.getProperties()).forEach(property -> {
                if (DataCloudMetadataHelper.getMetadataFromField(property, "DataCloudExtractAttribute").isPresent()) {
                    names.add(DWTypeUtils.getKey((KeyValuePairType)property));
                }
            });
        }
        if ((dependency = object.getDependsOn()) != null) {
            names.addAll(DataCloudMetadataHelper.collectAttributeNamesForObject(dependency, visited));
        }
        return names;
    }

    static {
        OBJECT_TYPE_LABELS.put("UNSTRUCTURED_DATA", "Unstructured");
        OBJECT_TYPE_LABELS.put("USER", "User");
        OBJECT_TYPE_LABELS.put("GROUP", "Group");
        OBJECT_TYPE_LABELS.put("PERMISSION", "Permission");
        OBJECT_TYPE_LABELS.put("ACTIVITY", "Activity");
    }
}

