%dw 2.8
import * from com::mulesoft::connectivity::datacloud::Metadata
import * from connectors::basicconnector::Module
import * from com::mulesoft::connectivity::decorator::Operation

var getPaginatedPetNames = paginated(operations."/pets".get, (param, pageValue) -> {
   value: pageValue,
   items: (pageValue.body.pets default []) as Array<Types.Pet>,
})

var paginatedPetNames = {
    name: "Pet",
    resolvedBy: getPaginatedPetNames
}

@DataCloudConnectorElement()
var connector = {
  name: "Variant Connector",
  label: "Label for the Variant Connector",
  description: "Description for the Variant Connector",
  displayName: "Variant Connector",
  releaseLevel: "IN_DEV",
  features: ["INGRESS","OBJECTBASED"],
  connection:  connectionProvider,
  testConnection: testConnection,
  version: "0.0.1",
  ingressDescription: "Variant Connector",
  vendor: "Mulesoft",
  objects: {
    pet: paginatedPetNames
  }
}
