/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.api.model;

import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudObjectModel;
import com.mulesoft.connectivity.datacloud.api.model.RateLimitConfigurationModel;
import com.mulesoft.connectivity.linkweave.api.model.ConnectorModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.salesforce.dataconnectors.api.model.connection.ConnectorFrameworkFeature;
import com.salesforce.dataconnectors.api.model.connection.ReleaseLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class DataCloudConnectorModel
extends ConnectorModel
implements Serializable {
    private final String label;
    private final String version;
    private final String vendor;
    private final @Nullable String description;
    private final String ingressDescription;
    private final @Nullable String egressDescription;
    private final ReleaseLevel releaseLevel;
    private final List<ConnectorFrameworkFeature> features;
    private final @Nullable String accessCheck;
    private final Map<ConnectorFrameworkFeature, Map<ConnectorFrameworkFeature.Config, String>> featuresConfig;
    private final Map<String, String> customErrorLabels;
    private final List<DataCloudConnectionModel> connections;
    private final Map<String, DataCloudObjectModel> objects;
    private final Map<String, DataCloudObjectModel> externalCallout;
    private final @Nullable TestConnectionModel testConnection;

    private DataCloudConnectorModel(String name, String label, @Nullable String accessCheck, @Nullable String description, String ingressDescription, @Nullable String egressDescription, ReleaseLevel releaseLevel, List<ConnectorFrameworkFeature> features, String version, String vendor, @Nullable Map<ConnectorFrameworkFeature, Map<// Could not load outer class - annotation placement on inner may be incorrect
    ConnectorFrameworkFeature.Config, String>> featuresConfig, @Nullable Map<String, String> customErrorLabels, List<DataCloudConnectionModel> connections, @Nullable String modelReference, Map<String, DataCloudObjectModel> objects, Map<String, @Nullable DataCloudObjectModel> externalCallout, @Nullable TestConnectionModel testConnection) {
        super(modelReference, name, label);
        this.label = label;
        this.accessCheck = accessCheck;
        this.description = description;
        this.ingressDescription = ingressDescription;
        this.egressDescription = egressDescription;
        this.releaseLevel = releaseLevel;
        this.features = features;
        this.version = version;
        this.vendor = vendor;
        this.featuresConfig = Objects.requireNonNullElse(featuresConfig, Map.of());
        this.customErrorLabels = Objects.requireNonNullElse(customErrorLabels, Map.of());
        this.connections = connections;
        this.objects = objects;
        this.externalCallout = externalCallout;
        this.testConnection = testConnection;
    }

    public String getLabel() {
        return this.label;
    }

    public Map<String, DataCloudObjectModel> getExternalCallout() {
        return this.externalCallout;
    }

    public @Nullable String getAccessCheck() {
        return this.accessCheck;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public String getIngressDescription() {
        return this.ingressDescription;
    }

    public @Nullable String getEgressDescription() {
        return this.egressDescription;
    }

    public ReleaseLevel getReleaseLevel() {
        return this.releaseLevel;
    }

    public List<ConnectorFrameworkFeature> getFeatures() {
        return this.features;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVendor() {
        return this.vendor;
    }

    public List<DataCloudConnectionModel> getConnections() {
        return this.connections;
    }

    public @Nullable TestConnectionModel getTestConnection() {
        return this.testConnection;
    }

    public Map<String, DataCloudObjectModel> getObjects() {
        return this.objects;
    }

    public Map<ConnectorFrameworkFeature, Map<ConnectorFrameworkFeature.Config, String>> getFeaturesConfig() {
        return this.featuresConfig;
    }

    public Map<String, String> getCustomErrorLabels() {
        return this.customErrorLabels;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ConnectorModel.Builder<DataCloudConnectorModel, Builder> {
        private @Nullable String name;
        private @Nullable String label;
        private @Nullable String accessCheck;
        private @Nullable String description;
        private @Nullable String version;
        private @Nullable String vendor;
        private @Nullable String ingressDescription;
        private @Nullable String egressDescription;
        private @Nullable ReleaseLevel releaseLevel;
        private @Nullable List<ConnectorFrameworkFeature> features;
        private @Nullable Map<ConnectorFrameworkFeature, Map<// Could not load outer class - annotation placement on inner may be incorrect
        ConnectorFrameworkFeature.Config, String>> featuresConfig;
        private @Nullable Map<String, String> customErrorLabels;
        private @Nullable List<DataCloudConnectionModel> connections = new ArrayList<DataCloudConnectionModel>();
        private @Nullable TestConnectionModel testConnection;
        private @Nullable Map<String, DataCloudObjectModel> objects;
        private @Nullable Map<String, RateLimitConfigurationModel> rateLimitConfigurationModels;
        private @Nullable Map<String, DataCloudObjectModel> externalCallout;

        public Builder withName(String name) {
            this.name = name;
            return this.getThis();
        }

        public Builder withLabel(String label) {
            this.label = label;
            return this.getThis();
        }

        public Builder withAccessCheck(@Nullable String accessCheck) {
            this.accessCheck = accessCheck;
            return this.getThis();
        }

        public Builder withDescription(@Nullable String description) {
            this.description = description;
            return this.getThis();
        }

        public Builder withIngressDescription(String ingressDescription) {
            this.ingressDescription = ingressDescription;
            return this.getThis();
        }

        public Builder withEgressDescription(@Nullable String egressDescription) {
            this.egressDescription = egressDescription;
            return this.getThis();
        }

        public Builder withReleaseLevel(String releaseLevel) {
            this.releaseLevel = ReleaseLevel.valueOf((String)releaseLevel);
            return this.getThis();
        }

        public Builder withFeatures(List<String> features) {
            ArrayList<ConnectorFrameworkFeature> frameworkFeatures = new ArrayList<ConnectorFrameworkFeature>();
            features.forEach(feature -> frameworkFeatures.add(ConnectorFrameworkFeature.valueOf((String)feature)));
            this.features = frameworkFeatures;
            return this.getThis();
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this.getThis();
        }

        public Builder withVendor(String vendor) {
            this.vendor = vendor;
            return this.getThis();
        }

        public Builder withFeatureConfigs(Map<String, Map<String, String>> featuresConfig) {
            this.featuresConfig = new HashMap<ConnectorFrameworkFeature, Map<ConnectorFrameworkFeature.Config, String>>();
            for (Map.Entry<String, Map<String, String>> feature : featuresConfig.entrySet()) {
                Map<String, String> configMap = feature.getValue();
                HashMap<ConnectorFrameworkFeature.Config, String> configs = new HashMap<ConnectorFrameworkFeature.Config, String>();
                for (Map.Entry<String, String> config : configMap.entrySet()) {
                    configs.put(ConnectorFrameworkFeature.Config.valueOf((String)config.getKey()), config.getValue());
                }
                this.featuresConfig.put(ConnectorFrameworkFeature.valueOf((String)feature.getKey()), configs);
            }
            return this.getThis();
        }

        public Builder withCustomErrorLabels(Map<String, String> customErrorLabels) {
            this.customErrorLabels = customErrorLabels;
            return this.getThis();
        }

        public Builder withConnections(List<DataCloudConnectionModel> connections) {
            this.connections = connections;
            return this.getThis();
        }

        public Builder withTestConnection(TestConnectionModel testConnection) {
            this.testConnection = testConnection;
            return this.getThis();
        }

        public Builder withObjects(Map<String, DataCloudObjectModel> objects) {
            this.objects = objects;
            return this.getThis();
        }

        public Builder withExternalCallout(Map<String, DataCloudObjectModel> externalCallout) {
            this.externalCallout = externalCallout;
            return this.getThis();
        }

        public Builder withDependencyOn(String objectName, String dependsOn) {
            DataCloudObjectModel dependsOnObjectModel = Objects.requireNonNull(this.objects.get(dependsOn), String.format("Object '%s' depends on object '%s', which is not listed as a connector object", objectName, dependsOn));
            Objects.requireNonNull(this.objects, "Call withObjects() first!").get(objectName).setDependsOn(dependsOnObjectModel);
            return this.getThis();
        }

        public Builder withRateLimitConfigurationModels(Map<String, RateLimitConfigurationModel> rateLimitConfigurationModels) {
            this.rateLimitConfigurationModels = rateLimitConfigurationModels;
            return this.getThis();
        }

        protected Builder getThis() {
            return this;
        }

        protected DataCloudConnectorModel createInstance() {
            this.validate();
            return new DataCloudConnectorModel(Objects.requireNonNull(this.name), Objects.requireNonNull(this.label), this.accessCheck, this.description, Objects.requireNonNull(this.ingressDescription), this.egressDescription, Objects.requireNonNull(this.releaseLevel), Objects.requireNonNull(this.features), Objects.requireNonNull(this.version), Objects.requireNonNull(this.vendor), this.featuresConfig, this.customErrorLabels, Objects.requireNonNull(this.connections), this.modelReference, Objects.requireNonNull(this.objects), this.externalCallout, this.testConnection);
        }

        private void validate() throws IllegalStateException {
            StringBuilder messages = new StringBuilder();
            if (this.name == null || this.name.isBlank()) {
                messages.append("Name is required\n");
            }
            if (this.label == null || this.label.isBlank()) {
                messages.append("Label is required\n");
            }
            if (this.version == null || this.version.isBlank()) {
                messages.append("Version is required\n");
            }
            if (this.releaseLevel == null) {
                messages.append("ReleaseLevel is required\n");
            }
            if (this.ingressDescription == null || this.ingressDescription.isBlank()) {
                messages.append("Ingress Description is required\n");
            }
            if (this.vendor == null || this.vendor.isBlank()) {
                messages.append("Vendor is required\n");
            }
            if (this.connections == null || this.connections.isEmpty()) {
                messages.append("At least one Connection Definition is required\n");
            }
            if (this.testConnection == null && this.missingTestConnectionInConnectionProviders()) {
                messages.append("Test Connection Model is required\n");
            }
            if (this.modelReference == null || this.modelReference.isBlank()) {
                messages.append("Model Reference is required\n");
            }
            if (this.objects == null || this.objects.isEmpty()) {
                messages.append("At least one Object is required\n");
            }
            if (!messages.isEmpty()) {
                throw new IllegalStateException(messages.toString());
            }
        }

        private boolean missingTestConnectionInConnectionProviders() {
            return this.connections != null && this.connections.stream().anyMatch(connection -> connection.getConnectionProviderModel().getTestConnection() == null);
        }
    }
}

