import noAuth, test from connectors::unstructured::connections::Connections

import O_api_users_get from connectors::unstructured::operations::O_api_users_get
import O_api_space_get from connectors::unstructured::operations::O_api_space_get
import O_api_permissions_get from connectors::unstructured::operations::O_api_permissions_get
import O_api_engagements_get from connectors::unstructured::operations::O_api_engagements_get
import O_api_groups_get from connectors::unstructured::operations::O_api_groups_get
import mapInputOperation from com::mulesoft::connectivity::decorator::Operation
import * from com::mulesoft::connectivity::datacloud::Metadata

var get_users_transform = mapInputOperation(O_api_users_get, (param:{})-> {
query:{ limit: "10"},
headers:{},
cookie:{}
})

var get_groups_transform = mapInputOperation(O_api_groups_get, (param:{})-> {
  query:{},
  headers:{},
  cookie:{}
})

type SpaceInput = {
    orgId:  @DataCloudExtractAttribute(value = "Org ID") String
}

var get_space_transform = mapInputOperation(O_api_space_get, (param: SpaceInput)-> {
  query:{ spaceId: param.spaceId},
  headers:{},
  cookie:{}
})

type PermissionInput = {
    spaceId: String
}

var get_space_id_permission_transform = mapInputOperation(O_api_permissions_get, (param: PermissionInput)-> {
  query:{ spaceId: param.spaceId},
  headers:{},
  cookie:{}
})

type EngagementInput = {
    siteId:  @DataCloudExtractAttribute(value = "Site ID") String
}

var get_engagements_transform = mapInputOperation(O_api_engagements_get, (param: EngagementInput)-> {
  query:{ spaceId: param.spaceId},
  headers:{},
  cookie:{}
})

var users = {
  name: "Users",
  'type': 'USER',
  resolvedBy: get_users_transform
}

var space = {
  name: "Space",
  'type': 'UNSTRUCTURED_DATA',
  resolvedBy: get_space_transform,
  isHidden : true
}

var permissions = {
  name: "Permissions",
  'type': 'PERMISSION',
  resolvedBy: get_space_id_permission_transform,
  dependsOn: {
    object: space,
    binding: (space) -> { spaceId: space.id}
  }
}

var groups = {
  name: "Groups",
  'type': 'GROUP',
  resolvedBy: get_groups_transform
}

var engagements = {
  name: "Engagements",
  'type': 'ACTIVITY',
  resolvedBy: get_engagements_transform
}

@DataCloudConnectorElement()
var connector = {
  name: "UnstructuredTest",
  label: "UnstructuredTest",
  description: "Description for Unstructiured Test",
  displayName: "Unstructiured Test Connector",
  ingressDescription: "Ingress description for Pagination Testing Connector",
  releaseLevel: "IN_DEV",
  features: ["INGRESS", "FILEBASED", "UNSTRUCTURED"],
  connection: noAuth,
  testConnection: test,
  version: "1.0.0",
  vendor: "Mulesoft",
  objects: {
    users: users,
    space: space,
    permissions: permissions,
    groups: groups,
    engagements: engagements
  }
}