%dw 2.8

import T_Cars from connectors::unstructured::Types::Types
import Error, Result, ResultFailure, failure, success from com::mulesoft::connectivity::Model

import Int32, Int64, Integer from com::mulesoft::connectivity::Types

import HttpConnection, HttpRequestType, HttpResponse from com::mulesoft::connectivity::transport::Http

import serializeCookies, serializeHeaders, withSerializationConfig from com::mulesoft::connectivity::transport::Serialization

type O_api_cars_get_Type = {
  "200": HttpResponse<Array<T_Cars>>,
  "400": HttpResponse<Any>,
  "500": HttpResponse<Any>,
  errorResponse: ResultFailure<O_api_cars_get_Type."400", Error<"status-400", "CLIENT_ERROR">> | ResultFailure<O_api_cars_get_Type."500", Error<"status-500", "SERVER_ERROR">> | ResultFailure<HttpResponse<Any>, Error<"status-unexpected", String>>,
  request: HttpRequestType<{| query: { offset?: Int32, limit?: String }, headers: Object, cookie: Object |}>,
  response: O_api_cars_get_Type."200"
}

var O_api_cars_get = {
  name: "GET /api/cars",
  displayName: "GET /api/cars",
  executor: (parameter: O_api_cars_get_Type.request, connection: HttpConnection): Result<O_api_cars_get_Type.response, O_api_cars_get_Type.errorResponse> -> do {
      var query = parameter.query default {} withSerializationConfig {}
      var headers = serializeHeaders(parameter.headers default {}, {})
      var cookie = serializeCookies(parameter.cookie default {}, {})
      var response = connection({
        method: "GET",
        path: "/api/cars",
        queryParams: query,
        headers: headers,
        cookie: cookie,
        (body: parameter.body) if (parameter.body?)
      })
      ---
      response match {
        case response200 if log(response200).status == 200 -> success(response200 as O_api_cars_get_Type."200")
        case response400 if response400.status == 400 -> failure(response400 as O_api_cars_get_Type."400", {
          kind: "status-400",
          categories: ["CLIENT_ERROR"]
        }, "Bad Request")
        case response500 if response500.status == 500 -> failure(response500 as O_api_cars_get_Type."500", {
          kind: "status-500",
          categories: ["SERVER_ERROR"]
        }, "Internal Server Error")
        else responsedefault-> failure(responsedefault, {
          kind: "status-unexpected",
          categories: []
        }, "Unexpected status code")
      }
    }
}

