%dw 2.8
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::transport::Serialization
import mapInputOperation from com::mulesoft::connectivity::decorator::Operation
import Label, HelpText from com::mulesoft::connectivity::decorator::Annotations
import Double, LWDateTime from com::mulesoft::connectivity::Types

type Types = {
  Error: {
    code: Number,
    message: String
  },
  CurrentWeather: {
    id: Number <~ { semanticTerms: ["primaryKey"] },
    location: String,
    temperature: Double,
    humidity: Double,
    windSpeed: Double,
    description: String,
    timestamp: LWDateTime
  }
}

type CurrentWeatherOperationType = {
  "200": HttpResponse<Types.CurrentWeather>,
  "400": HttpResponse<Types.Error>,
  "500": HttpResponse<Types.Error>,
  errorResponse: ResultFailure<CurrentWeatherOperationType."400", Error<"status-400", "CLIENT_ERROR">> | ResultFailure<CurrentWeatherOperationType."500", Error<"status-500", "SERVER_ERROR">> | ResultFailure<HttpResponse<Any>, Error<"status-unexpected", String>>,
  request: HttpRequestType<{|
    query: {
      location?: String,
      units?: String
    },
    headers: Object,
    cookie: Object
  |}>,
  response: CurrentWeatherOperationType."200"
}

var operations = {
  "/current": {
    get: {
      name: "getCurrentWeather",
      displayName: "Get Current Weather",
      executor: (parameter: CurrentWeatherOperationType.request, connection: HttpConnection): Result<CurrentWeatherOperationType.response, CurrentWeatherOperationType.errorResponse> -> do {
        var query = parameter.query default {} withSerializationConfig {}
        var headers = serializeHeaders(parameter.headers default {}, {})
        var cookie = serializeCookies(parameter.cookie default {}, {})
        var response = connection({
          method: "GET",
          path: "/current",
          queryParams: query,
          headers: headers,
          cookie: cookie
        })
        ---
        response match {
          case response200 if response200.status == 200 -> success(response200 as CurrentWeatherOperationType."200")
          case response400 if response400.status == 400 -> failure(response400 as CurrentWeatherOperationType."400", {
            kind: "status-400",
            categories: ["CLIENT_ERROR"]
          }, "Bad Request")
          case response500 if response500.status == 500 -> failure(response500 as CurrentWeatherOperationType."500", {
            kind: "status-500",
            categories: ["SERVER_ERROR"]
          }, "Internal Server Error")
          else responsedefault -> failure(responsedefault, {
            kind: "status-unexpected",
            categories: []
          }, "Unexpected status code")
        }
      }
    }
  }
}

var curatedOperations = {
    "/current": {
        get: operations."/current".get mapInputOperation (param: {}) -> {
              query: {},
              headers: {},
              cookie: {}
          }
    }
}

@ConnectionElement()
var basicAuthConnectionProvider = defineBasicHttpConnectionProvider<BasicAuthSchema & { baseUri: String }>(
     (connectionInfo) -> {username: connectionInfo.username, password: connectionInfo.password},
     (parameter) -> {baseUri: parameter.baseUri}
 ) ++ {
  validate: defineTestConnection(mapInputOperation(operations."/current".get, (param: {}) -> {
    query: {},
    headers: {},
    cookie: {}
  }), (response) -> {
    isValid: response.value.status == 200,
    message:
      if (response.success is true)
        "Connection test succeeded"
      else
        "Connection test failed - Http status code: " ++ response.value.status,
    (error: write(response.value.body, "application/dw") as String) if (response.success is false)
  })
}

var oAuthConnectionProvider = defineOAuth2Connection<{
       baseUri: @Label(value = "Base URI") @HelpText(value = "Base URI to access Sharepoint APIs") String,
       accessToken: @Label(value = "Access Token") @HelpText(value = "OAuth 2.0 Access Token") OAuth2AuthSchema.accessToken
  }>(
    (parameter) -> {accessToken: parameter.accessToken},
    (parameter) -> {baseUri: parameter.baseUri},
    {
       grantType: 'authorizationCode',
       authorizationUrl: "http://localhost/authorize",
       tokenUrl: "http://localhost/token",
       scopes: ["test"]
    }
)
