/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.api.loader;

import com.mulesoft.connectivity.datacloud.api.loader.DataCloudConnectionLoader;
import com.mulesoft.connectivity.datacloud.api.loader.DataCloudConnectionProviderLoader;
import com.mulesoft.connectivity.datacloud.api.loader.DataCloudRateLimiterConfigurationLoader;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionProviderModel;
import com.mulesoft.connectivity.datacloud.api.model.RateLimitConfigurationModel;
import com.mulesoft.connectivity.linkweave.api.DataWeaveObjectReference;
import com.mulesoft.connectivity.linkweave.api.DataWeaveReference;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class DataCloudConnectionLoaderTest {
    @Mock
    private DataCloudConnectionProviderLoader connectionProviderLoader;
    @Mock
    private DataCloudRateLimiterConfigurationLoader rateLimiterConfigurationLoader;
    @Mock
    private DataWeaveObjectReference dwObject;
    @Mock
    private DataCloudConnectionProviderModel connectionProviderModel;
    private DataCloudConnectionLoader loader;

    DataCloudConnectionLoaderTest() {
    }

    @BeforeEach
    void setUp() {
        this.loader = new DataCloudConnectionLoader(this.connectionProviderLoader, this.rateLimiterConfigurationLoader);
    }

    @Test
    void testCreateBuilder() {
        DataCloudConnectionModel.Builder builder = this.loader.createBuilder();
        Assertions.assertNotNull((Object)builder, (String)"Builder should not be null");
    }

    @Test
    void testConfigureBuilderWithRequiredPropertiesOnly() {
        String connectionName = "testConnection";
        DataWeaveObjectReference connectionProviderRef = (DataWeaveObjectReference)Mockito.mock(DataWeaveObjectReference.class);
        Mockito.when((Object)this.dwObject.getObjectProperty("provider")).thenReturn(Optional.of(connectionProviderRef));
        Mockito.when((Object)this.dwObject.getObjectProperty("rateLimiterConfigs")).thenReturn(Optional.empty());
        Mockito.when((Object)((DataCloudConnectionProviderModel)this.connectionProviderLoader.loadModel((DataWeaveReference)connectionProviderRef, connectionName))).thenReturn((Object)this.connectionProviderModel);
        DataCloudConnectionModel.Builder builder = this.loader.createBuilder();
        this.loader.configureBuilder(builder, this.dwObject, connectionName);
        ((DataCloudConnectionProviderLoader)Mockito.verify((Object)this.connectionProviderLoader)).loadModel((DataWeaveReference)connectionProviderRef, connectionName);
    }

    @Test
    void testConfigureBuilderWithRateLimiterConfigs() {
        DataWeaveObjectReference connectionProviderRef = (DataWeaveObjectReference)Mockito.mock(DataWeaveObjectReference.class);
        DataWeaveObjectReference rateLimiterRef = (DataWeaveObjectReference)Mockito.mock(DataWeaveObjectReference.class);
        DataWeaveObjectReference configRef = (DataWeaveObjectReference)Mockito.mock(DataWeaveObjectReference.class);
        RateLimitConfigurationModel rateLimitModel = (RateLimitConfigurationModel)Mockito.mock(RateLimitConfigurationModel.class);
        String connectionName = "testConnection";
        Mockito.when((Object)this.dwObject.getObjectProperty("provider")).thenReturn(Optional.of(connectionProviderRef));
        Mockito.when((Object)this.dwObject.getObjectProperty("rateLimiterConfigs")).thenReturn(Optional.of(rateLimiterRef));
        Mockito.when((Object)((DataCloudConnectionProviderModel)this.connectionProviderLoader.loadModel((DataWeaveReference)connectionProviderRef, connectionName))).thenReturn((Object)this.connectionProviderModel);
        Map.Entry<String, DataWeaveObjectReference> entry = Map.entry("testConfig", configRef);
        Mockito.when((Object)configRef.asObjectReference()).thenReturn((Object)configRef);
        Mockito.when((Object)rateLimiterRef.properties()).thenReturn(Stream.of(entry));
        Mockito.when((Object)rateLimitModel.getId()).thenReturn((Object)"testConfig");
        Mockito.when((Object)((RateLimitConfigurationModel)this.rateLimiterConfigurationLoader.loadModel((DataWeaveReference)configRef, "testConfig"))).thenReturn((Object)rateLimitModel);
        DataCloudConnectionModel.Builder builder = this.loader.createBuilder();
        this.loader.configureBuilder(builder, this.dwObject, connectionName);
        ((DataCloudConnectionProviderLoader)Mockito.verify((Object)this.connectionProviderLoader)).loadModel((DataWeaveReference)connectionProviderRef, connectionName);
        ((DataCloudRateLimiterConfigurationLoader)Mockito.verify((Object)this.rateLimiterConfigurationLoader)).loadModel((DataWeaveReference)configRef, "testConfig");
    }
}

