%dw 2.8
import DataCloudConnectorElement from com::mulesoft::connectivity::datacloud::Metadata
import * from connectors::weather::Module

@DataCloudConnectorElement()
var connector = {
  name: "DateFormatTestConnector",
  label: "A simple connector to test date formats",
  description: "A simple connector to test date formats",
  displayName: "Date Format Test Connector",
  releaseLevel: "IN_DEV",
  features: ["INGRESS","FILEBASED"],
  connections: {
    basicAuth: basicAuthConnectionProvider
  },
  version: "0.0.1",
  ingressDescription: "Date Format Test Connector",
  vendor: "Mulesoft",
  objects: {
    currentWeather: {
      name: "CurrentWeather",
      resolvedBy: curatedOperations."/current".get,
      connection: "basicAuth"
    },
  },
  config: {
    dateFormats: {
      date: "yyyy-MM-dd",
      'date-time': "yyyy-MM-dd'T'HH:mm:ss.SSSZ",
    }
  }
} 
