%dw 2.8
import DataCloudConnectorElement from com::mulesoft::connectivity::datacloud::Metadata
import * from connectors::weather::Module

@DataCloudConnectorElement()
var connector = {
  name: "WeatherServiceConnector",
  label: "Weather Service Connector",
  description: "A connector for accessing weather information and forecasts",
  displayName: "Weather Service Connector",
  releaseLevel: "IN_DEV",
  features: ["INGRESS","FILEBASED"],
  connections: {
    basicAuth: basicAuthConnectionProvider,
    restApiAuth: restApiOAuthConnectionProvider,
    graphApiAuth: graphApiOAuthConnectionProvider
  },
  version: "0.0.1",
  ingressDescription: "Weather Service Connector",
  vendor: "Mulesoft",
  objects: {
      currentWeather: {
        name: "CurrentWeather",
        resolvedBy: curatedOperations."/current".get,
        connection: "basicAuth"
      },
      forecast: {
        name: "Forecast",
        resolvedBy: curatedOperations."/forecast".get,
        connection: "restApiAuth"
      },
      alert: {
        name: "Alert",
        resolvedBy: curatedOperations."/alerts".get,
        connection: "graphApiAuth"
      }
    }
} 
