%dw 2.7
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::transport::Serialization
import * from com::mulesoft::connectivity::decorator::Operation
import * from com::mulesoft::connectivity::decorator::PaginationStrategies

type Types = {
  Error: {
    code: Number,
    message: String
  },
  NewPet: {
    name: String,
    tag?: String
  },
  Pet: Types.NewPet & { id: Number },
  Accessory: {
      id: Number <~ { semanticTerms: ["primaryKey"] },
      name: String,
      "type": String,
      description: String,
      price: Number,
    }
}


type OperationTypes = {
  "/pets": {
    get: {
      request: HttpRequestType<{|
        query: {
          tags?: Array<String>,
          limit?: Number
        },
        headers: Object,
        cookie: Object
      |}>,
      response: Array<Types.Pet> | Types.Error,
      "200": Array<Types.Pet>,
      "default": Types.Error
    }
  },
  "/accessories": {
    get: {
      request: HttpRequestType<{|
        query: {
          limit?: Number
        },
        headers: Object,
        cookie: Object
      |}>,
      response: Array<Types.Accessory> | Types.Error,
      "200": Array<Types.Accessory>,
      "default": Types.Error
    }
  }
}

type PaginatedOperationTypes = {
  findPets: {
    request: {
        category?: String,
        limit?: Number
      }
  }
}

var operations = {
  "/pets": {
    get: {
      name: "findPets",
      displayName: "findPets",
      executor: (parameter: OperationTypes."/pets".get.request, connection: HttpConnection): Result<HttpResponse<OperationTypes."/pets".get."200">, ResultFailure<HttpResponse<Any>, Error>> -> do {
        var query = parameter.query default {} withSerializationConfig {}
        var headers = serializeHeaders(parameter.headers default {}, {})
        var cookie = serializeCookies(parameter.cookie default {}, {})
        ---
        success(connection({
          method: "GET",
          path: "/pets",
          queryParams: query,
          headers: headers,
          cookie: cookie,
          (body: parameter.body) if (parameter.body?)
        }) as HttpResponse<OperationTypes."/pets".get."200">)
      }
    }
  },
  "/accessories": {
      get: {
        name: "findAccessories",
        displayName: "findAccessories",
        executor: (parameter: OperationTypes."/accessories".get.request, connection: HttpConnection): Result<HttpResponse<OperationTypes."/accessories".get."200">, ResultFailure<HttpResponse<OperationTypes."/accessories".get."default">,Error>> -> do {
          var query = parameter.query default {} withSerializationConfig {}
          var headers = serializeHeaders(parameter.headers default {}, {})
          var cookie = serializeCookies(parameter.cookie default {}, {})
          ---
          success(connection({
            method: "GET",
            path: "/accessories",
            queryParams: query,
            headers: headers,
            cookie: cookie,
            (body: parameter.body) if (parameter.body?)
          }) as HttpResponse<OperationTypes."/accessories".get."200">)
        }
      }
  }
}

var paginatedOperations = {
  findPets: offsetPaginated(
    operations."/pets".get,
    (page) -> page.body default [],
    (param) -> param.query.from default 0,
    (param, offset) -> (param update { case from at .query.from! -> offset })
    ) mapInputOperation (param: PaginatedOperationTypes.findPets.request) -> {
      query: {
          (category: param.category!) if (param.category?),
          (limit: param.limit!) if (param.limit?),
          (from: param.from as Number) if (param.from?)
      },
      headers: {},
      cookie: {}
    }
}

var mockConnectionProvider : HttpConnectionProvider<Object, { "type": "custom" }> = {
    authenticationType: {"type": "custom"},
    connect: (parameter) -> (httpRequest: HttpRequester) -> do {
      var path = httpRequest.path
      var response = {contentType: "application/json", status: 200, headers: {}, cookies: {}}
      var pet1 = {id: 1, name: "Name1", category: "Cat1", tag: "Tag1", createdAt: "2024-01-01"}
      var pet2 = {id: 2, name: "Name2", category: "Cat2", tag: "Tag2", createdAt: "2024-01-01"}
      ---
      path match {
        case "/pets" -> do {
          var petPage = if ((httpRequest.queryParams.offset default 0) == 0) [pet1] else [pet2]
          ---
          if (httpRequest.method == "GET")
            response ++ {body: petPage}
          else
            response ++ {body: pet1}
        }
      }
    }
}

var connections = {
   mockAuth: mockConnectionProvider
}

@TestConnectionElement()
var testConnection: HttpTestConnection = {
  validate: (connection) -> {
    isValid: connection({
      method: "GET",
      path: "/pets",
      queryParams: {},
      headers: {},
      cookie: {}
    }).status == 200
  }
}




