%dw 2.8
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::transport::Serialization
import mapInputOperation from com::mulesoft::connectivity::decorator::Operation
import Label, HelpText from com::mulesoft::connectivity::decorator::Annotations
import Double, LWDateTime from com::mulesoft::connectivity::Types

type Types = {
  Error: {
    code: Number,
    message: String
  },
  CurrentWeather: {
    id: Number <~ { semanticTerms: ["primaryKey"] },
    location: String,
    temperature: Double,
    humidity: Double,
    windSpeed: Double,
    description: String,
    timestamp: LWDateTime
  },
  Forecast: {
    id: Number <~ { semanticTerms: ["primaryKey"] },
    location: String,
    date: String <~ { format: "date" },
    highTemp: Double,
    lowTemp: Double,
    description: String,
    precipitation: Double
  },
  Alert: {
    id: Number <~ { semanticTerms: ["primaryKey"] },
    location: String,
    'type': String,
    severity: String,
    description: String,
    startTime: LWDateTime,
    endTime: LWDateTime
  }
}

type CurrentWeatherOperationType = {
  "200": HttpResponse<Types.CurrentWeather>,
  "400": HttpResponse<Types.Error>,
  "500": HttpResponse<Types.Error>,
  errorResponse: ResultFailure<CurrentWeatherOperationType."400", Error<"status-400", "CLIENT_ERROR">> | ResultFailure<CurrentWeatherOperationType."500", Error<"status-500", "SERVER_ERROR">> | ResultFailure<HttpResponse<Any>, Error<"status-unexpected", String>>,
  request: HttpRequestType<{|
    query: {
      location?: String,
      units?: String
    },
    headers: Object,
    cookie: Object
  |}>,
  response: CurrentWeatherOperationType."200"
}

type ForecastOperationType = {
  "200": HttpResponse<Array<Types.Forecast>>,
  "400": HttpResponse<Types.Error>,
  "500": HttpResponse<Types.Error>,
  errorResponse: ResultFailure<ForecastOperationType."400", Error<"status-400", "CLIENT_ERROR">> | ResultFailure<ForecastOperationType."500", Error<"status-500", "SERVER_ERROR">> | ResultFailure<HttpResponse<Any>, Error<"status-unexpected", String>>,
  request: HttpRequestType<{|
    query: {
      location?: String,
      days?: Number,
      units?: String
    },
    headers: Object,
    cookie: Object
  |}>,
  response: ForecastOperationType."200"
}

type AlertsOperationType = {
  "200": HttpResponse<Array<Types.Alert>>,
  "400": HttpResponse<Types.Error>,
  "500": HttpResponse<Types.Error>,
  errorResponse: ResultFailure<AlertsOperationType."400", Error<"status-400", "CLIENT_ERROR">> | ResultFailure<AlertsOperationType."500", Error<"status-500", "SERVER_ERROR">> | ResultFailure<HttpResponse<Any>, Error<"status-unexpected", String>>,
  request: HttpRequestType<{|
    query: {
      location?: String,
      active?: Boolean
    },
    headers: Object,
    cookie: Object
  |}>,
  response: AlertsOperationType."200"
}

var operations = {
  "/current": {
    get: {
      name: "getCurrentWeather",
      displayName: "Get Current Weather",
      executor: (parameter: CurrentWeatherOperationType.request, connection: HttpConnection): Result<CurrentWeatherOperationType.response, CurrentWeatherOperationType.errorResponse> -> do {
        var query = parameter.query default {} withSerializationConfig {}
        var headers = serializeHeaders(parameter.headers default {}, {})
        var cookie = serializeCookies(parameter.cookie default {}, {})
        var response = connection({
          method: "GET",
          path: "/current",
          queryParams: query,
          headers: headers,
          cookie: cookie
        })
        ---
        response match {
          case response200 if response200.status == 200 -> success(response200 as CurrentWeatherOperationType."200")
          case response400 if response400.status == 400 -> failure(response400 as CurrentWeatherOperationType."400", {
            kind: "status-400",
            categories: ["CLIENT_ERROR"]
          }, "Bad Request")
          case response500 if response500.status == 500 -> failure(response500 as CurrentWeatherOperationType."500", {
            kind: "status-500",
            categories: ["SERVER_ERROR"]
          }, "Internal Server Error")
          else responsedefault -> failure(responsedefault, {
            kind: "status-unexpected",
            categories: []
          }, "Unexpected status code")
        }
      }
    }
  },
  "/forecast": {
    get: {
      name: "getForecast",
      displayName: "Get Weather Forecast",
      executor: (parameter: ForecastOperationType.request, connection: HttpConnection): Result<ForecastOperationType.response, ForecastOperationType.errorResponse> -> do {
        var query = parameter.query default {} withSerializationConfig {}
        var headers = serializeHeaders(parameter.headers default {}, {})
        var cookie = serializeCookies(parameter.cookie default {}, {})
        var response = connection({
          method: "GET",
          path: "/forecast",
          queryParams: query,
          headers: headers,
          cookie: cookie
        })
        ---
        response match {
          case response200 if response200.status == 200 -> success(response200 as ForecastOperationType."200")
          case response400 if response400.status == 400 -> failure(response400 as ForecastOperationType."400", {
            kind: "status-400",
            categories: ["CLIENT_ERROR"]
          }, "Bad Request")
          case response500 if response500.status == 500 -> failure(response500 as ForecastOperationType."500", {
            kind: "status-500",
            categories: ["SERVER_ERROR"]
          }, "Internal Server Error")
          else responsedefault -> failure(responsedefault, {
            kind: "status-unexpected",
            categories: []
          }, "Unexpected status code")
        }
      }
    }
  },
  "/alerts": {
    get: {
      name: "getAlerts",
      displayName: "Get Weather Alerts",
      executor: (parameter: AlertsOperationType.request, connection: HttpConnection): Result<AlertsOperationType.response, AlertsOperationType.errorResponse> -> do {
        var query = parameter.query default {} withSerializationConfig {}
        var headers = serializeHeaders(parameter.headers default {}, {})
        var cookie = serializeCookies(parameter.cookie default {}, {})
        var response = connection({
          method: "GET",
          path: "/alerts",
          queryParams: query,
          headers: headers,
          cookie: cookie
        })
        ---
        response match {
          case response200 if response200.status == 200 -> success(response200 as AlertsOperationType."200")
          case response400 if response400.status == 400 -> failure(response400 as AlertsOperationType."400", {
            kind: "status-400",
            categories: ["CLIENT_ERROR"]
          }, "Bad Request")
          case response500 if response500.status == 500 -> failure(response500 as AlertsOperationType."500", {
            kind: "status-500",
            categories: ["SERVER_ERROR"]
          }, "Internal Server Error")
          else responsedefault -> failure(responsedefault, {
            kind: "status-unexpected",
            categories: []
          }, "Unexpected status code")
        }
      }
    }
  }
}

var curatedOperations = {
    "/current": {
        get: operations."/current".get mapInputOperation (param: {}) -> {
              query: {},
              headers: {},
              cookie: {}
          }
    },
    "/forecast": {
        get: operations."/forecast".get mapInputOperation (param: {}) -> {
              query: {},
              headers: {},
              cookie: {}
          }
    },
    "/alerts": {
        get: operations."/alerts".get mapInputOperation (param: {}) -> {
              query: {},
              headers: {},
              cookie: {}
          }
    }
}

@ConnectionElement()
var basicAuthConnectionProvider = defineBasicHttpConnectionProvider<BasicAuthSchema & { baseUri: String }>(
     (connectionInfo) -> {username: connectionInfo.username, password: connectionInfo.password},
     (parameter) -> {baseUri: parameter.baseUri}
 ) ++ {
  validate: defineTestConnection(mapInputOperation(operations."/current".get, (param: {}) -> {
    query: {},
    headers: {},
    cookie: {}
  }), (response) -> {
    isValid: response.value.status == 200,
    message:
      if (response.success is true)
        "Connection test succeeded"
      else
        "Connection test failed - Http status code: " ++ response.value.status,
    (error: write(response.value.body, "application/dw") as String) if (response.success is false)
  })
}

var oAuthConnectionProvider = defineOAuth2Connection<{
       baseUri: @Label(value = "Base URI") @HelpText(value = "Base URI to access Sharepoint APIs") String,
       accessToken: @Label(value = "Access Token") @HelpText(value = "OAuth 2.0 Access Token") OAuth2AuthSchema.accessToken
  }>(
    (parameter) -> {accessToken: parameter.accessToken},
    (parameter) -> {baseUri: parameter.baseUri},
    {
       grantType: 'authorizationCode',
       authorizationUrl: "http://localhost/authorize",
       tokenUrl: "http://localhost/token",
       scopes: ["test"]
    }
)

@ConnectionElement()
var restApiOAuthConnectionProvider = oAuthConnectionProvider ++ {
    validate: defineTestConnection(mapInputOperation(operations."/forecast".get, (param: {}) -> {
      query: {},
      headers: {},
      cookie: {}
    }), (response) -> {
      isValid: response.value.status == 200,
      message:
        if (response.success is true)
          "Connection test succeeded"
        else
          "Connection test failed - Http status code: " ++ response.value.status,
      (error: write(response.value.body, "application/dw") as String) if (response.success is false)
    })
}

@ConnectionElement()
var graphApiOAuthConnectionProvider = oAuthConnectionProvider ++ {
    validate: defineTestConnection(mapInputOperation(operations."/alerts".get, (param: {}) -> {
      query: {},
      headers: {},
      cookie: {}
    }), (response) -> {
      isValid: response.value.status == 200,
      message:
        if (response.success is true)
          "Connection test succeeded"
        else
          "Connection test failed - Http status code: " ++ response.value.status,
      (error: write(response.value.body, "application/dw") as String) if (response.success is false)
    })
}
