/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.api.loader;

import com.mulesoft.connectivity.datacloud.api.loader.DataCloudConnectionProviderLoader;
import com.mulesoft.connectivity.datacloud.api.loader.DataCloudRateLimiterConfigurationLoader;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionProviderModel;
import com.mulesoft.connectivity.datacloud.api.model.RateLimitConfigurationModel;
import com.mulesoft.connectivity.linkweave.api.DataWeaveObjectReference;
import com.mulesoft.connectivity.linkweave.api.DataWeaveReference;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class DataCloudConnectionLoader
extends ModelLoader<DataCloudConnectionModel, DataCloudConnectionModel.Builder, DataWeaveObjectReference> {
    private final DataCloudConnectionProviderLoader dataCloudConnectionProviderLoader;
    private final DataCloudRateLimiterConfigurationLoader dataCloudRateLimiterConfigurationLoader;
    private Map<String, RateLimitConfigurationModel> rateLimitConfigurationModels;

    public DataCloudConnectionLoader(DataCloudConnectionProviderLoader dataCloudConnectionProviderLoader, DataCloudRateLimiterConfigurationLoader dataCloudRateLimiterConfigurationLoader) {
        this.dataCloudConnectionProviderLoader = dataCloudConnectionProviderLoader;
        this.dataCloudRateLimiterConfigurationLoader = dataCloudRateLimiterConfigurationLoader;
        this.rateLimitConfigurationModels = new HashMap<String, RateLimitConfigurationModel>();
    }

    protected DataCloudConnectionModel.Builder createBuilder() {
        return new DataCloudConnectionModel.Builder();
    }

    protected DataCloudConnectionModel.Builder configureBuilder(DataCloudConnectionModel.Builder builder, DataWeaveObjectReference dwObject, @Nullable String name) {
        String connectionName = name != null ? name : dwObject.getPath();
        builder.withConnectionProviderModel((DataCloudConnectionProviderModel)this.dataCloudConnectionProviderLoader.loadModel((DataWeaveReference)dwObject.getObjectProperty("provider").orElse(dwObject), connectionName));
        dwObject.getObjectProperty("rateLimiterConfigs").ifPresent(ref -> {
            Map<String, RateLimitConfigurationModel> configs = ref.properties().map(p -> (RateLimitConfigurationModel)this.dataCloudRateLimiterConfigurationLoader.loadModel((DataWeaveReference)((DataWeaveReference)p.getValue()).asObjectReference(), (String)p.getKey())).collect(Collectors.toMap(RateLimitConfigurationModel::getId, Function.identity()));
            builder.withRateLimitConfigurationModels(configs);
            this.rateLimitConfigurationModels.putAll(configs);
        });
        builder.withName(connectionName);
        return builder;
    }

    @Generated
    public Map<String, RateLimitConfigurationModel> getRateLimitConfigurationModels() {
        return this.rateLimitConfigurationModels;
    }
}

