%dw 2.8
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::Types
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::transport::Serialization
import mapInputOperation from com::mulesoft::connectivity::decorator::Operation

type Types = {
  Error: {
    code: Number,
    message: String
  },
  WeatherStation: {
    id: Number <~ { semanticTerms: ["primaryKey"] },
    name: String,
    location: {
      latitude: Double,
      longitude: Double
    },
    elevation: Double,
    status: String
  },
  Measurement: {
    id: Number <~ { semanticTerms: ["primaryKey"] },
    stationId: Number,
    timestamp: LWDateTime,
    temperature: Double,
    humidity: Double,
    pressure: Double,
    windSpeed: Double
  },
  Alert: {
    id: Number <~ { semanticTerms: ["primaryKey"] },
    stationId: Number,
    'type': String,
    severity: String,
    message: String,
    timestamp: LWDateTime
  },
  AlertSummaryPDF: {
    id: Number <~ { semanticTerms: ["primaryKey"] },
    stationId: Number,
    'type': String,
    severity: String,
    message: String,
    timestamp: LWDateTime,
    pdfContent: Binary
  }
}

type OperationTypes = {
  "/{city}/stations": {
    get: {
      request: HttpRequestType<{|
        uriParams: {
          city: String
        },
        query: {
          status?: String | Null,
          limit?: Number | Null,
          pageMarker?: String | Array | Null,
        },
        headers: Object,
        cookie: Object
      |}>,
      response: Array<Types.WeatherStation> | Types.Error,
      "200": Array<Types.WeatherStation>,
      "default": Types.Error
    }
  },
  "/{stationId}/measurements": {
    get: {
      request: HttpRequestType<{|
        uriParams: {
          stationId: Number
        },
        query: {
          fromDate?: String | Null,
          toDate?: String | Null,
          limit?: Number | Null,
        },
        headers: Object,
        cookie: Object
      |}>,
      response: Array<Types.Measurement> | Types.Error,
      "200": Array<Types.Measurement>,
      "default": Types.Error
    }
  },
  "/{stationId}/alerts": {
    get: {
      request: HttpRequestType<{|
        uriParams: {
          stationId: Number
        },
        query: {
          severity?: String | Null,
          limit?: Number | Null,
        },
        headers: Object,
        cookie: Object
      |}>,
      response: Array<Types.Alert> | Types.Error,
      "200": Array<Types.Alert>,
      "default": Types.Error
    }
  },
  "/alerts/{id}/summary": {
    get: {
      request: HttpRequestType<{|
        uriParams: {
          id: Number
        },
        headers: {
          Accept: String
        } & Object,
        cookie: Object
      |}>,
      response: Binary | Types.Error,
      "200": Binary,
      "default": Types.Error
    }
  }
}

var operations = {
  "/{city}/stations": {
    get: {
      name: "findStations",
      displayName: "Find Weather Stations",
      executor: (parameter: OperationTypes."/{city}/stations".get.request, connection: HttpConnection): Result<HttpResponse<OperationTypes."/{city}/stations".get."200">, ResultFailure<HttpResponse<OperationTypes."/{city}/stations".get."default">,Error>> -> do {
        var query = parameter.query default {} withSerializationConfig {}
        var headers = serializeHeaders(parameter.headers default {}, {})
        var cookie = serializeCookies(parameter.cookie default {}, {})
        ---
        success(connection({
          method: "GET",
          path: "/$(parameter.uriParams.city)/stations",
          queryParams: query,
          headers: headers,
          cookie: cookie,
          (body: parameter.body) if (parameter.body?)
        }) as HttpResponse<OperationTypes."/{city}/stations".get."200">)
      }
    }
  },
  "/{stationId}/measurements": {
    get: {
      name: "findMeasurements",
      displayName: "Find Weather Measurements",
      executor: (parameter: OperationTypes."/{stationId}/measurements".get.request, connection: HttpConnection): Result<HttpResponse<OperationTypes."/{stationId}/measurements".get."200">, ResultFailure<HttpResponse<OperationTypes."/{stationId}/measurements".get."default">,Error>> -> do {
        var query = parameter.query default {} withSerializationConfig {}
        var headers = serializeHeaders(parameter.headers default {}, {})
        var cookie = serializeCookies(parameter.cookie default {}, {})
        ---
        success(connection({
          method: "GET",
          path: "/$(parameter.uriParams.stationId)/measurements",
          queryParams: query,
          headers: headers,
          cookie: cookie,
          (body: parameter.body) if (parameter.body?)
        }) as HttpResponse<OperationTypes."/{stationId}/measurements".get."200">)
      }
    }
  },
  "/{stationId}/alerts": {
    get: {
      name: "findAlerts",
      displayName: "Find Weather Alerts",
      executor: (parameter: OperationTypes."/{stationId}/alerts".get.request, connection: HttpConnection): Result<HttpResponse<OperationTypes."/{stationId}/alerts".get."200">, ResultFailure<HttpResponse<OperationTypes."/{stationId}/alerts".get."default">,Error>> -> do {
        var query = parameter.query default {} withSerializationConfig {}
        var headers = serializeHeaders(parameter.headers default {}, {})
        var cookie = serializeCookies(parameter.cookie default {}, {})
        ---
        success(connection({
          method: "GET",
          path: "/$(parameter.uriParams.stationId)/alerts",
          queryParams: query,
          headers: headers,
          cookie: cookie,
          (body: parameter.body) if (parameter.body?)
        }) as HttpResponse<OperationTypes."/{stationId}/alerts".get."200">)
      }
    }
  },
  "/alerts/{id}/summary": {
    get: {
      name: "getAlertSummaryPDF",
      displayName: "Get Alert Summary as PDF",
      executor: (parameter: OperationTypes."/alerts/{id}/summary".get.request, connection: HttpConnection): Result<HttpResponse<OperationTypes."/alerts/{id}/summary".get."200">, ResultFailure<HttpResponse<OperationTypes."/alerts/{id}/summary".get."default">,Error>> -> do {
        var headers = serializeHeaders((parameter.headers default {}) ++ {"Accept": "application/pdf"}, {})
        var cookie = serializeCookies(parameter.cookie default {}, {})
        ---
        success(connection({
          method: "GET",
          path: "/alerts/$(parameter.uriParams.id)/summary",
          headers: headers,
          cookie: cookie
        }) as HttpResponse<Binary>)
      }
    }
  }
}

// Mapped operations with input transformations
var getStations = operations."/{city}/stations".get mapInputOperation((param: {city: String, status?: String, limit?: Number}) -> {
    uriParams: {
        city: param.city
    },
    query: {
        status: param.status,
        limit: param.limit
    },
    headers: {},
    cookie: {}
})

var getMeasurements = operations."/{stationId}/measurements".get mapInputOperation((param: {stationId: Number, fromDate?: String, toDate?: String, limit?: Number}) -> {
    uriParams: {
        stationId: param.stationId
    },
    query: {
        fromDate: param.fromDate,
        toDate: param.toDate,
        limit: param.limit
    },
    headers: {},
    cookie: {}
})

var getAlerts = operations."/{stationId}/alerts".get mapInputOperation((param: {stationId: Number, severity?: String, limit?: Number}) -> {
    uriParams: {
        stationId: param.stationId
    },
    query: {
        severity: param.severity,
        limit: param.limit
    },
    headers: {},
    cookie: {}
})

var getAlertSummaryPDF = operations."/alerts/{id}/summary".get mapInputOperation((param: {id: Number}) -> {
    uriParams: {
        id: param.id
    },
    headers: {
        Accept: "application/pdf"
    },
    cookie: {}
})

// Export all operations
var mappedOperations = {
    stations: getStations,
    measurements: getMeasurements,
    alerts: getAlerts,
    alertSummary: getAlertSummaryPDF
}

@TestConnectionElement()
var testConnection: HttpTestConnection = {
  validate: (connection) -> {
    isValid: connection({
      method: "GET",
      path: "/testConnection",
      queryParams: {},
      headers: {},
      cookie: {}
    }).status == 200
  }
}

@ConnectionElement()
var basicAuthConnectionProvider = defineBasicHttpConnectionProvider<{baseUri: String, user: String <~{semanticTerms: ["username"]}, pass: String  <~ {semanticTerms: ["password"]}}>(
    (parameter) -> {username: parameter.user, password: parameter.pass},
    (parameter) -> {baseUri: parameter.baseUri}
)

@ConnectionElement()
var apiKeyConnectionProvider = defineApiKeyHttpConnectionProvider<{baseUri: String, apiKey: String <~ {semanticTerms: ["apiKey"]}}>(
    (parameter) -> {apiKey: parameter.apiKey},
    (parameter) -> {baseUri: parameter.baseUri},
    {in: 'cookie', name: "apiKeyCookie"}
)

@ConnectionElement()
var oauthConnectionProvider = defineOAuth2Connection<{baseUri: String, accessToken: String}>(
    (parameter) -> {accessToken: parameter.accessToken},
        (parameter) -> {baseUri: parameter.baseUri},
        {
            grantType: 'authorizationCode',
            authorizationUrl: "http://localhost/authorize",
            tokenUrl: "http://localhost/token",
            refreshUrl: "http://localhost/token",
            scopes: ["test"]
        }
)

// Export all connection providers
var connectionProviders = {
    basic: basicAuthConnectionProvider,
    apiKey: apiKeyConnectionProvider,
    oauth2: oauthConnectionProvider
} 
