%dw 2.7
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::transport::Serialization
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::decorator::Operation
import * from com::mulesoft::connectivity::decorator::Trigger

type Types = {
    Error: {
      code: Number,
      message: String
    },
    Song: {
      id: Number,
      name: String
    }
}

type OperationTypes = {
  "/api/songs": {
      get: {
            request: HttpRequestType<{|
                query?: {
                  offset?: String,
                  snapshotId?: Number | Null
                },
                headers?: Object,
                cookie?: Object
            |}>,
            response: {
                songs: Array<Types.Song>,
                nextLink?: String
            } | Types.Error,
            "200": {
                songs: Array<Types.Song>,
                nextLink?: String
            },
            "default": Types.Error
        }
  }
}


var operations = {
    "/api/songs": {
        get: {
            name: "songs",
            displayName: "Songs",
            executor: (parameter: OperationTypes."/api/songs".get.request, connection: HttpConnection): Result<HttpResponse<OperationTypes."/api/songs".get."200">, ResultFailure<HttpResponse<Any>, Error>> -> do {
                var query =  parameter.query default {} withSerializationConfig {}
                var headers = serializeHeaders(parameter.headers default {}, {})
                var cookie = serializeCookies(parameter.cookie default {}, {})
                ---
                success(connection({
                  method: "GET",
                  path: "/api/songs",
                  queryParams: (if (query.snapshotId != null)
                                               {"filter": "id>" ++ query.snapshotId as String}
                                           else
                                               query),
                  headers: headers,
                  cookie: cookie,
                  (body: parameter.body) if (parameter.body?)
                }) as HttpResponse<OperationTypes."/api/songs".get."200">)
            }
        }
    }
}

var paginatedOperations = {
    "/api/songs": {
        get: (operations."/api/songs".get paginated (param, pageValue) -> {
            items: (pageValue.body.songs default []) as Array<Types.Song>,
            (nextPage: {
                args: param update {
                    case query at .query! -> parseQueryParameters(pageValue.body.nextLink default "")
                }
            }) if (!isEmpty(pageValue.body.nextLink) and !isEmpty(pageValue.body.nextLink))
        })
    }
}

var triggerStrategy = {

                 items: (result ) -> result.items,
                 item: (item) -> item,
                 watermark: (result, item) -> item.id! as Number,
                 identity: (item) -> item.id as String,
                 watermarkCompareTo: DefaultWatermarkComparison

}

var newSongTrigger = {

                           name: "NewSongTrigger",
                           displayName: "New Song Trigger",
                           metadata: {
                               order: "ASC",
                               paginated: true
                           },
                           strategy: triggerStrategy,
                           operation: paginatedOperations."/api/songs".get,
                           inputMapper: (param:{||}, watermark: Number|Null):OperationTypes."/api/songs".get.request  -> {
                               query: {
                                        snapshotId: watermark
                                      },
                               headers: {},
                               cookie: {}
                           } as OperationTypes."/api/songs".get.request,
                           initialWatermark: (triggerInput, connection) -> -1
                     }

var triggers = {
"/api/songs": newSongTrigger
}

@TestConnectionElement()
var testConnection: HttpTestConnection = {
  validate: (connection) -> {
    isValid: connection({
      method: "GET",
      path: "/ping",
      queryParams: {},
      headers: {},
      cookie: {}
    }).status == 200
  }
}

type ConnectionAttributes = {baseUri: String, user: String <~{semanticTerms: ["username"]}, pass: String  <~ {semanticTerms: ["password"]}}

@ConnectionElement()
var connectionProvider = defineBasicHttpConnectionProvider<ConnectionAttributes>(
    (parameter) -> {username: parameter.user, password: parameter.pass},
    (parameter) -> {baseUri: parameter.baseUri}
)
