%dw 2.8

import O_api_cars_get from connectors::unstructured::operations::O_api_cars_get
import TestConnectionElement from com::mulesoft::connectivity::Metadata

import defineTestConnection from com::mulesoft::connectivity::Model

import mapInputOperation from com::mulesoft::connectivity::decorator::Operation

import HttpConnectionProviderSchema, defineHttpConnection from com::mulesoft::connectivity::transport::Http

@TestConnectionElement()
var test = {
  validate: defineTestConnection(mapInputOperation(O_api_cars_get, (param: {}) -> {
    query: {},
    headers: {},
    cookie: {}
  }), (response) -> {
    isValid: response.value.status == 200,
    message: 
      if (response.success is true)
        "Connection test succeeded"
      else
        "Connection test failed - Http status code: " ++ response.value.status,
    (error: write(response.value.body, "application/dw") as String) if (response.success is false)
  })
}

var noAuth = {
  connect: defineHttpConnection<HttpConnectionProviderSchema, HttpConnectionProviderSchema>((v) -> v, (v) -> v, (auth, req) -> req),
  authenticationType: {
    "type": "custom",
    subType: "no-auth"
  }
}

