/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.api.loader;

import com.mulesoft.connectivity.datacloud.api.model.RateLimitConfigurationModel;
import com.mulesoft.connectivity.linkweave.api.DataWeaveObjectReference;
import com.mulesoft.connectivity.linkweave.api.DataWeaveReference;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.salesforce.dataconnectors.api.service.RateLimiter.RateIntervalUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;

public class DataCloudRateLimiterConfigurationLoader
extends ModelLoader<RateLimitConfigurationModel, RateLimitConfigurationModel.Builder, DataWeaveObjectReference> {
    protected RateLimitConfigurationModel.Builder createBuilder() {
        return new RateLimitConfigurationModel.Builder();
    }

    protected RateLimitConfigurationModel.Builder configureBuilder(RateLimitConfigurationModel.Builder builder, DataWeaveObjectReference dwObject, @Nullable String name) {
        builder.withId(Objects.requireNonNull(name, "Rate limiter key cannot be null"));
        this.buildIdProvider(builder, dwObject);
        dwObject.getProperty("enabled").ifPresent(prop -> builder.withEnabled(prop.asBoolean()));
        dwObject.getProperty("tenantScoped").ifPresent(prop -> builder.withTenantScoped(prop.asBoolean()));
        DataCloudRateLimiterConfigurationLoader.buildRateModel(builder, dwObject);
        this.buildRequestModel(builder, dwObject);
        return builder;
    }

    private void buildIdProvider(RateLimitConfigurationModel.Builder builder, DataWeaveObjectReference dwObject) {
        Optional maybeIdProviderObj = dwObject.getProperty("idProvider");
        if (maybeIdProviderObj.isEmpty()) {
            return;
        }
        DataWeaveObjectReference idProviderObj = ((DataWeaveReference)maybeIdProviderObj.get()).asObjectReference();
        List<RateLimitConfigurationModel.InputSelector> inputSelectors = idProviderObj.getProperty("inputSelectors").map(DataWeaveReference::getValue).map(array -> (List)array).map(array -> array.stream().map(obj -> {
            String key = String.valueOf(obj.get("key"));
            boolean secured = Boolean.parseBoolean(String.valueOf(obj.get("secured")));
            return new RateLimitConfigurationModel.InputSelector(key, secured);
        }).toList()).orElse(Collections.emptyList());
        Map additionalKeyValues = idProviderObj.getProperty("additionalKeyValues").map(DataWeaveReference::getValue).orElse(null);
        if (!inputSelectors.isEmpty()) {
            builder.withRateLimiterIdProvider(new RateLimitConfigurationModel.IdProviderModel(inputSelectors, additionalKeyValues));
        }
    }

    private void buildRequestModel(RateLimitConfigurationModel.Builder builder, DataWeaveObjectReference dwObject) {
        Optional maybeRequestObj = dwObject.getProperty("request");
        if (maybeRequestObj.isEmpty()) {
            return;
        }
        DataWeaveObjectReference requestObj = ((DataWeaveReference)maybeRequestObj.get()).asObjectReference();
        requestObj.getProperty("permits").ifPresent(prop -> {
            long permitsValue = Long.parseLong(String.valueOf(prop.getValue()));
            if (permitsValue <= 0L) {
                throw new IllegalStateException("Permits value must be a positive number greater than 0");
            }
            builder.withPermits(permitsValue);
        });
        requestObj.getProperty("timeout").ifPresent(prop -> {
            long timeoutValue = Long.parseLong(String.valueOf(prop.getValue()));
            if (timeoutValue <= 0L) {
                throw new IllegalStateException("Timeout value must be a positive number greater than 0");
            }
            builder.withTimeout(timeoutValue);
        });
        requestObj.getProperty("timeoutUnit").ifPresent(prop -> builder.withTimeoutUnit(TimeUnit.valueOf(prop.asString())));
    }

    private static void buildRateModel(RateLimitConfigurationModel.Builder builder, DataWeaveObjectReference dwObject) {
        try {
            DataWeaveObjectReference rateObj = dwObject.requireObjectProperty("rate");
            long value = Long.parseLong(String.valueOf(rateObj.requireProperty("value").getValue()));
            long interval = Long.parseLong(String.valueOf(rateObj.requireProperty("interval").getValue()));
            if (value <= 0L || interval <= 0L) {
                throw new IllegalStateException("Rate configuration values must be positive numbers greater than 0");
            }
            String intervalUnit = rateObj.requireProperty("intervalUnit").asString();
            RateLimitConfigurationModel.RateModel rateModel = new RateLimitConfigurationModel.RateModel(value, interval, RateIntervalUnit.valueOf((String)intervalUnit));
            builder.withRate(rateModel);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Rate configuration values must be positive numbers greater than 0");
        }
    }
}

