%dw 2.7
import noAuth, test from connectors::unstructured::connections::Connections

import O_api_cars_get_paginated from connectors::unstructured::pagination::O_api_cars_get_pagination
import mapInputOperation from com::mulesoft::connectivity::decorator::Operation

import O_api_cars_image_get from connectors::unstructured::operations::O_api_cars_image_get
import * from com::mulesoft::connectivity::datacloud::Metadata

var downloadImage = O_api_cars_image_get mapInputOperation((param:{'customUrl.url': String})-> {
query: { imageUrl: param.'customUrl.url'},
headers:{},
cookie:{}
})


var getCars = O_api_cars_get_paginated mapInputOperation((param:{})-> {
query:{ limit: "10"},
headers:{},
cookie:{}
})

@DataCloudConnectorElement()
var connector = {
  name: "UnstructuredTest",
  label: "UnstructuredTest",
  description: "Description for Unstructiured Test",
  displayName: "Unstructiured Test Connector",
  ingressDescription: "Ingress description for Pagination Testing Connector",
  releaseLevel: "IN_DEV",
  features: ["INGRESS", "OBJECTBASED"],
  connection: noAuth,
  testConnection: test,
  version: "1.0.0",
  vendor: "Mulesoft",
  objects: {
    cars: {
      name: "Cars",
      resolvedBy: getCars,
      contentProvider: downloadImage
    }
  }
}

