%dw 2.7

import operations,connectionProvider, testConnection from connectors::basicconnector::Module
import * from com::mulesoft::connectivity::datacloud::Metadata

var objects = {
        pet: {
          name: "Pet",
          resolvedBy: operations."/pets".get
        },
        medicalrecord: {
          name: "MedicalRecord",
          resolvedBy: operations."/medicalrecords".get
        },
        accessory: {
          name: "Accessory",
          resolvedBy: operations."/accessories".get,
          isHidden: true
        }
}

@DataCloudConnectorElement()
var connector = {
  name: "ConnectorWithHiddenObject",
  label: "Connector With Hidden Object",
  description: "Description for Hidden Object Connector",
  displayName: "Connector With Hidden Object",
  ingressDescription: "Ingress description for Unstructured Hidden Test Connector",
  releaseLevel: "IN_DEV",
  features: ["INGRESS", "OBJECTBASED"],
  connection: connectionProvider,
  testConnection: testConnection,
  version: "1.0.0",
  vendor: "Mulesoft",
  objects: objects
}

