/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.api.loader;

import com.mulesoft.connectivity.datacloud.api.loader.DataCloudModelLoaderFactory;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectorModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudObjectModel;
import com.mulesoft.connectivity.datacloud.api.utils.DataCloudMetadataHelper;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.salesforce.dataconnectors.api.model.connection.Attribute;
import com.salesforce.dataconnectors.api.model.connection.ConnectorOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ModuleComponentsFactory;
import org.mule.weave.v2.runtime.SimpleModuleComponentFactory;
import org.mule.weave.v2.ts.ObjectType;
import org.mule.weave.v2.ts.SimpleReferenceType;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Seq;

class DataCloudMetadataHelperTest {
    DataCloudMetadataHelperTest() {
    }

    @Test
    void basicAttributeTest() {
        DataWeaveScriptingEngine dataWeaveScriptingEngine = DataWeaveScriptingEngine.apply((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveScriptingEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)modelLoader.loadConnector("connectors::twilio::Connector::connector");
        List attributes = DataCloudMetadataHelper.getExtractAttributes((DataCloudConnectorModel)connectorModel);
        Assertions.assertEquals((int)1, (int)attributes.size());
        Assertions.assertEquals((Object)"accountId", (Object)((Attribute)attributes.get(0)).getName());
        Assertions.assertEquals((Object)"Account ID", (Object)((Attribute)attributes.get(0)).getLabel());
    }

    @Test
    void multiAttributeTest() {
        DataWeaveScriptingEngine dataWeaveScriptingEngine = DataWeaveScriptingEngine.apply((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveScriptingEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)modelLoader.loadConnector("connectors::twilio::Variants::Connector::connector");
        List attributes = DataCloudMetadataHelper.getExtractAttributes((DataCloudConnectorModel)connectorModel);
        Assertions.assertEquals((int)2, (int)attributes.size());
        Assertions.assertEquals((Object)"accountId", (Object)((Attribute)attributes.get(0)).getName());
        Assertions.assertEquals((Object)"Account ID", (Object)((Attribute)attributes.get(0)).getLabel());
        Assertions.assertEquals((Object)"messageId", (Object)((Attribute)attributes.get(1)).getName());
        Assertions.assertEquals((Object)"Message ID", (Object)((Attribute)attributes.get(1)).getLabel());
    }

    @Test
    void noExtractAttributesTest() {
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)Mockito.mock(DataCloudConnectorModel.class);
        List attributes = DataCloudMetadataHelper.getExtractAttributes((DataCloudConnectorModel)connectorModel);
        Assertions.assertTrue((boolean)attributes.isEmpty());
    }

    @Test
    void extractAttributesNotDefinedTest() {
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)Mockito.mock(DataCloudConnectorModel.class);
        DataCloudObjectModel dataCloudObjectModel = (DataCloudObjectModel)Mockito.mock(DataCloudObjectModel.class);
        ExecutableComponentModel resolvedBy = (ExecutableComponentModel)Mockito.mock(ExecutableComponentModel.class);
        TypeModel operationInputType = (TypeModel)Mockito.mock(TypeModel.class);
        ArrayList newProperties = new ArrayList();
        ObjectType objectType = new ObjectType((Seq)JavaConverters.asScalaBuffer(newProperties).toList(), false, false);
        Mockito.when((Object)dataCloudObjectModel.getResolvedBy()).thenReturn((Object)resolvedBy);
        Mockito.when((Object)resolvedBy.getInputType()).thenReturn((Object)operationInputType);
        Mockito.when((Object)operationInputType.getDataType()).thenReturn((Object)objectType);
        Mockito.when((Object)connectorModel.getObjects()).thenReturn(Map.of("Test", dataCloudObjectModel));
        List attributes = DataCloudMetadataHelper.getExtractAttributes((DataCloudConnectorModel)connectorModel);
        Assertions.assertTrue((boolean)attributes.isEmpty());
    }

    @Test
    void extractAttributesTestWithObjectTypes() {
        DataWeaveScriptingEngine dataWeaveScriptingEngine = DataWeaveScriptingEngine.apply((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveScriptingEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)modelLoader.loadConnector("connectors::unstructured::connectorVariants::Connector_4::connector");
        List attributes = DataCloudMetadataHelper.getExtractAttributes((DataCloudConnectorModel)connectorModel);
        Assertions.assertEquals((int)4, (int)attributes.size());
        Assertions.assertEquals((Object)"siteId", (Object)((Attribute)attributes.get(0)).getName());
        Assertions.assertEquals((Object)"objectName", (Object)((Attribute)attributes.get(1)).getName());
        Assertions.assertEquals((Object)"orgId", (Object)((Attribute)attributes.get(2)).getName());
        Assertions.assertEquals((Object)"objectType", (Object)((Attribute)attributes.get(3)).getName());
        Assertions.assertEquals((int)5, (int)((Attribute)attributes.get(3)).getOptions().size());
        Assertions.assertEquals((Object)"Permission", (Object)((ConnectorOption)((Attribute)attributes.get(3)).getOptions().get(0)).getLabel());
        Assertions.assertEquals((Object)"Group", (Object)((ConnectorOption)((Attribute)attributes.get(3)).getOptions().get(1)).getLabel());
        Assertions.assertEquals((Object)"Unstructured", (Object)((ConnectorOption)((Attribute)attributes.get(3)).getOptions().get(2)).getLabel());
        Assertions.assertEquals((Object)"User", (Object)((ConnectorOption)((Attribute)attributes.get(3)).getOptions().get(3)).getLabel());
        Assertions.assertEquals((Object)"Activity", (Object)((ConnectorOption)((Attribute)attributes.get(3)).getOptions().get(4)).getLabel());
    }

    @Test
    void getFieldPatternWithPatternAnnotationTest() {
        String script = "%dw 2.9\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"Pattern\")\nannotation Pattern(value: String)\n\ntype MyObject = {\n    apiKey: @Pattern(value = \"[A-Z]{2}-[0-9]{4}\") String\n}\nvar v: MyObject = {\n    apiKey: \"AB-1234\"\n}\n---\nv";
        DataWeaveScriptingEngine dataWeaveScriptingEngine = new DataWeaveScriptingEngine();
        Option weaveTypeOpt = dataWeaveScriptingEngine.inferTypeOf(script);
        ObjectType weaveType = (ObjectType)((SimpleReferenceType)weaveTypeOpt.get()).resolveType();
        KeyValuePairType field = DWTypeUtils.requireFieldByName((org.mule.weave.v2.api.tooling.ts.ObjectType)weaveType, (String)"apiKey");
        Assertions.assertEquals((Object)"[A-Z]{2}-[0-9]{4}", (Object)DataCloudMetadataHelper.getFieldPattern((KeyValuePairType)field));
    }
}

