%dw 2.8
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::transport::Serialization
import LWDateTime, Double, Int64 from com::mulesoft::connectivity::Types
import DataCloudSemanticTerms from com::mulesoft::connectivity::datacloud::Metadata
import SemanticTerms from com::mulesoft::connectivity::decorator::Annotations

type Types = {
  Error: {
    code: Number,
    message: String
  },
  NewPet: {
    name: String,
    tag?: String | Null
  },
  Pet: Types.NewPet & {
    id: @DataCloudSemanticTerms(value = ["primaryKey"]) Number,
  },
  Accessory: {
    id: @DataCloudSemanticTerms(value = ["primaryKey"]) Number,
    name: String,
    "type": String,
    description: String,
    price: Double,
  },
  MedicalRecord: {
    id: @DataCloudSemanticTerms(value = ["primaryKey"]) Int64,
    petId: @DataCloudSemanticTerms(value = ["primaryKey"]) Number,
    visitDate: LWDateTime,
    description: String,
    veterinarian: String
  }
}

type OperationTypes = {
  "/pets": {
    get: {
      request: HttpRequestType<{|
        query: {
          tags?: Array<String>,
          limit?: Number,
          pageMarker: String | Array
        },
        headers: Object,
        cookie: Object
      |}>,
      response: Array<Types.Pet> | Types.Error,
      "200": Array<Types.Pet>,
      "default": Types.Error
    }
  },
  "/medicalrecords": {
    get: {
      request: HttpRequestType<{|
        query: {
          limit?: Number
        },
        headers: Object,
        cookie: Object
      |}>,
      response: Array<Types.MedicalRecord> | Types.Error,
      "200": Array<Types.MedicalRecord>,
      "default": Types.Error
    }
  },
  "/accessories": {
      get: {
        request: HttpRequestType<{|
          query: {
            limit?: Number
          },
          headers: Object,
          cookie: Object
        |}>,
        response: Array<Types.Accessory> | Types.Error,
        "200": Array<Types.Accessory>,
        "default": Types.Error
      }
    }
}

var operations = {
  "/pets": {
    get: {
      name: "findPets",
      displayName: "findPets",
      executor: (parameter: OperationTypes."/pets".get.request, connection: HttpConnection): Result<HttpResponse<OperationTypes."/pets".get."200">, ResultFailure<HttpResponse<OperationTypes."/pets".get."default">,Error>> -> do {
        var query = parameter.query default {} withSerializationConfig {}
        var headers = serializeHeaders(parameter.headers default {}, {})
        var cookie = serializeCookies(parameter.cookie default {}, {})
        ---
        success(connection({
          method: "GET",
          path: "/pets",
          queryParams: query,
          headers: headers,
          cookie: cookie,
          (body: parameter.body) if (parameter.body?)
        }) as HttpResponse<OperationTypes."/pets".get."200">)
      }
    }
  },
  "/medicalrecords": {
      get: {
        name: "findMedicalRecords",
        displayName: "findMedicalRecords",
        executor: (parameter: OperationTypes."/medicalrecords".get.request, connection: HttpConnection): Result<HttpResponse<OperationTypes."/medicalrecords".get."200">, ResultFailure<HttpResponse<OperationTypes."/medicalrecords".get."default">,Error>> -> do {
          var query = parameter.query default {} withSerializationConfig {}
          var headers = serializeHeaders(parameter.headers default {}, {})
          var cookie = serializeCookies(parameter.cookie default {}, {})
          ---
          success(connection({
            method: "GET",
            path: "/medicalrecords",
            queryParams: query,
            headers: headers,
            cookie: cookie,
            (body: parameter.body) if (parameter.body?)
          }) as HttpResponse<OperationTypes."/medicalrecords".get."200">)
        }
      }
    },
    "/accessories": {
        get: {
          name: "findAccessories",
          displayName: "findAccessories",
          executor: (parameter: OperationTypes."/accessories".get.request, connection: HttpConnection): Result<HttpResponse<OperationTypes."/accessories".get."200">, ResultFailure<HttpResponse<OperationTypes."/accessories".get."default">,Error>> -> do {
            var query = parameter.query default {} withSerializationConfig {}
            var headers = serializeHeaders(parameter.headers default {}, {})
            var cookie = serializeCookies(parameter.cookie default {}, {})
            ---
            success(connection({
              method: "GET",
              path: "/accessories",
              queryParams: query,
              headers: headers,
              cookie: cookie,
              (body: parameter.body) if (parameter.body?)
            }) as HttpResponse<OperationTypes."/accessories".get."200">)
          }
        }
    }
}

@TestConnectionElement()
var testConnection: HttpTestConnection = {
  validate: (connection) -> {
    isValid: connection({
      method: "GET",
      path: "/testConnection",
      queryParams: {},
      headers: {},
      cookie: {}
    }).status == 200
  }
}

@ConnectionElement()
var connectionProvider = defineBasicHttpConnectionProvider<{baseUri: String, user: @SemanticTerms(value = ["username"]) String, pass: @SemanticTerms(value = ["password"]) String}>(
    (parameter) -> {username: parameter.user, password: parameter.pass},
    (parameter) -> {baseUri: parameter.baseUri}
)
