import T_Engagements from connectors::unstructured::Types::Types
import Error, Result, ResultFailure, success from com::mulesoft::connectivity::Model
import Int32 from com::mulesoft::connectivity::Types
import HttpConnection, HttpRequestType, HttpResponse from com::mulesoft::connectivity::transport::Http
import serializeCookies, serializeHeaders, withSerializationConfig from com::mulesoft::connectivity::transport::Serialization

type O_api_engagements_get_Type = {
  "200": HttpResponse<Array<T_Engagements>>,
  "400": HttpResponse<Any>,
  "500": HttpResponse<Any>,
  errorResponse: ResultFailure<O_api_engagements_get_Type."400", Error<"status-400", "CLIENT_ERROR">> | ResultFailure<O_api_engagements_get_Type."500", Error<"status-500", "SERVER_ERROR">> | ResultFailure<HttpResponse<Any>, Error<"status-unexpected", String>>,
  request: HttpRequestType<{| query: { offset?: Int32, limit?: String }, headers: Object, cookie: Object |}>,
  response: O_api_engagements_get_Type."200"
}

var O_api_engagements_get = {
  name: "GET /api/engagements",
  displayName: "GET /api/engagements",
  executor: (parameter: O_api_engagements_get_Type.request, connection: HttpConnection): Result<O_api_engagements_get_Type.response, O_api_engagements_get_Type.errorResponse> -> do {
    var query = parameter.query default {} withSerializationConfig {}
    var headers = serializeHeaders(parameter.headers default {}, {})
    var cookie = serializeCookies(parameter.cookie default {}, {})
    var response = connection({
      method: "GET",
      path: "/api/engagements",
      queryParams: query,
      headers: headers,
      cookie: cookie
    })
    ---
    response match {
      case response200 if response200.status == 200 -> success(response200 as O_api_engagements_get_Type."200")
    }
  }
} 