/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.api.model;

import com.mulesoft.connectivity.linkweave.api.model.Model;
import com.salesforce.dataconnectors.api.service.RateLimiter.RateIntervalUnit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class RateLimitConfigurationModel
extends Model {
    private final String id;
    private final @Nullable IdProviderModel idProviderModel;
    private final boolean enabled;
    private final boolean tenantScoped;
    private final RateModel rate;
    private final RequestModel request;

    public RateLimitConfigurationModel(String id, @Nullable IdProviderModel idProviderModel, boolean enabled, boolean tenantScoped, RateModel rate, RequestModel request, @Nullable String modelReference) {
        super(modelReference);
        this.id = id;
        this.idProviderModel = idProviderModel;
        this.enabled = enabled;
        this.tenantScoped = tenantScoped;
        this.rate = rate;
        this.request = request;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public @Nullable IdProviderModel getIdProviderModel() {
        return this.idProviderModel;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public boolean isTenantScoped() {
        return this.tenantScoped;
    }

    @Generated
    public RateModel getRate() {
        return this.rate;
    }

    @Generated
    public RequestModel getRequest() {
        return this.request;
    }

    public record IdProviderModel(@Nullable List<InputSelector> inputSelectors, @Nullable Map<String, String> additionalKeyValues) {
    }

    public record RateModel(long value, long interval, RateIntervalUnit intervalUnit) {
    }

    public record RequestModel(long permits, long timeoutValue, TimeUnit timeoutUnit) {
    }

    public static class Builder
    extends Model.Builder<RateLimitConfigurationModel, Builder> {
        private @Nullable String id;
        private @Nullable IdProviderModel idProviderModel;
        private boolean enabled = true;
        private boolean tenantScoped = true;
        private @Nullable RateModel rate;
        private long permits = 1L;
        private long timeoutValue = 1L;
        private TimeUnit timeoutUnit = TimeUnit.HOURS;

        public Builder withId(String id) {
            this.id = id;
            return this.getThis();
        }

        public Builder withRateLimiterIdProvider(IdProviderModel idProviderModel) {
            this.idProviderModel = idProviderModel;
            return this.getThis();
        }

        public Builder withEnabled(boolean enabled) {
            this.enabled = enabled;
            return this.getThis();
        }

        public Builder withTenantScoped(boolean tenantScoped) {
            this.tenantScoped = tenantScoped;
            return this.getThis();
        }

        public Builder withRate(RateModel rate) {
            this.rate = rate;
            return this.getThis();
        }

        public Builder withRequest(RequestModel request) {
            this.permits = request.permits();
            this.timeoutValue = request.timeoutValue();
            this.timeoutUnit = request.timeoutUnit();
            return this.getThis();
        }

        public Builder withPermits(long permits) {
            this.permits = permits;
            return this.getThis();
        }

        public Builder withTimeout(long timeoutValue) {
            this.timeoutValue = timeoutValue;
            return this.getThis();
        }

        public Builder withTimeoutUnit(TimeUnit timeoutUnit) {
            this.timeoutUnit = timeoutUnit;
            return this.getThis();
        }

        protected RateLimitConfigurationModel createInstance() {
            return new RateLimitConfigurationModel(Objects.requireNonNull(this.id, "id cannot be null"), this.idProviderModel, this.enabled, this.tenantScoped, Objects.requireNonNull(this.rate, "rate cannot be null"), new RequestModel(this.permits, this.timeoutValue, this.timeoutUnit), this.modelReference);
        }

        protected Builder getThis() {
            return this;
        }
    }

    public record InputSelector(String key, boolean secured) {
    }
}

