/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.api.loader;

import com.mulesoft.connectivity.datacloud.api.loader.DataCloudModelLoaderFactory;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectorModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudObjectModel;
import com.mulesoft.connectivity.datacloud.api.model.RateLimitConfigurationModel;
import com.mulesoft.connectivity.linkweave.api.loader.InvalidConnectorException;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.salesforce.dataconnectors.api.service.RateLimiter.RateIntervalUnit;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ModuleComponentsFactory;
import org.mule.weave.v2.runtime.SimpleModuleComponentFactory;

class DataCloudRateLimiterConfigurationLoaderTest {
    private DataWeaveScriptingEngine dataWeaveEngine;
    private LanguageModelLoader<DataCloudConnectorModel, DataCloudConnectorModel.Builder> modelLoader;

    DataCloudRateLimiterConfigurationLoaderTest() {
    }

    @BeforeEach
    void setUp() {
        this.dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        this.modelLoader = new LanguageModelLoader(this.dataWeaveEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
    }

    @Test
    void rateLimiterConfigurationsLoadTest() {
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)this.modelLoader.loadConnector("connectors::ratelimits::Connector::connector");
        DataCloudConnectionModel connectionModel = (DataCloudConnectionModel)connectorModel.getConnections().get(0);
        Map rateLimitConfigurationModels = connectionModel.getRateLimitConfigurationModels();
        Assertions.assertNotNull((Object)rateLimitConfigurationModels);
        Assertions.assertEquals((int)2, (int)rateLimitConfigurationModels.size());
        RateLimitConfigurationModel userRateConfig = (RateLimitConfigurationModel)rateLimitConfigurationModels.get("user");
        Assertions.assertNotNull((Object)userRateConfig);
        Assertions.assertTrue((boolean)userRateConfig.isEnabled());
        Assertions.assertTrue((boolean)userRateConfig.isTenantScoped());
        Assertions.assertNotNull((Object)userRateConfig.getIdProviderModel());
        List inputSelectors = userRateConfig.getIdProviderModel().inputSelectors();
        Assertions.assertNotNull((Object)inputSelectors);
        Assertions.assertEquals((int)2, (int)inputSelectors.size());
        Assertions.assertEquals((Object)"clientId", (Object)((RateLimitConfigurationModel.InputSelector)inputSelectors.get(0)).key());
        Assertions.assertFalse((boolean)((RateLimitConfigurationModel.InputSelector)inputSelectors.get(0)).secured());
        Assertions.assertEquals((Object)"refreshToken", (Object)((RateLimitConfigurationModel.InputSelector)inputSelectors.get(1)).key());
        Assertions.assertTrue((boolean)((RateLimitConfigurationModel.InputSelector)inputSelectors.get(1)).secured());
        Assertions.assertNull((Object)userRateConfig.getIdProviderModel().additionalKeyValues());
        RateLimitConfigurationModel.RateModel userRate = userRateConfig.getRate();
        Assertions.assertNotNull((Object)userRate);
        Assertions.assertEquals((long)500L, (long)userRate.value());
        Assertions.assertEquals((long)1L, (long)userRate.interval());
        Assertions.assertEquals((Object)RateIntervalUnit.HOURS, (Object)userRate.intervalUnit());
        RateLimitConfigurationModel.RequestModel userRequest = userRateConfig.getRequest();
        Assertions.assertNotNull((Object)userRequest);
        Assertions.assertEquals((long)1L, (long)userRequest.permits());
        Assertions.assertEquals((long)1L, (long)userRequest.timeoutValue());
        Assertions.assertEquals((Object)((Object)TimeUnit.HOURS), (Object)((Object)userRequest.timeoutUnit()));
        RateLimitConfigurationModel siteAndRegionRateConfig = (RateLimitConfigurationModel)rateLimitConfigurationModels.get("cityAndRegion");
        Assertions.assertNotNull((Object)siteAndRegionRateConfig);
        Assertions.assertTrue((boolean)siteAndRegionRateConfig.isEnabled());
        Assertions.assertFalse((boolean)siteAndRegionRateConfig.isTenantScoped());
        Assertions.assertNotNull((Object)siteAndRegionRateConfig.getIdProviderModel());
        inputSelectors = siteAndRegionRateConfig.getIdProviderModel().inputSelectors();
        Assertions.assertNotNull((Object)inputSelectors);
        Assertions.assertEquals((int)1, (int)inputSelectors.size());
        Assertions.assertEquals((Object)"city", (Object)((RateLimitConfigurationModel.InputSelector)inputSelectors.get(0)).key());
        Map additionalKeyValues = siteAndRegionRateConfig.getIdProviderModel().additionalKeyValues();
        Assertions.assertNotNull((Object)additionalKeyValues);
        Assertions.assertEquals((int)1, (int)additionalKeyValues.size());
        Assertions.assertEquals((Object)"uswest", additionalKeyValues.get("regionId"));
        RateLimitConfigurationModel.RateModel siteAndRegionRate = siteAndRegionRateConfig.getRate();
        Assertions.assertNotNull((Object)siteAndRegionRate);
        Assertions.assertEquals((long)10000L, (long)siteAndRegionRate.value());
        Assertions.assertEquals((long)60L, (long)siteAndRegionRate.interval());
        Assertions.assertEquals((Object)RateIntervalUnit.MINUTES, (Object)siteAndRegionRate.intervalUnit());
        RateLimitConfigurationModel.RequestModel request = siteAndRegionRateConfig.getRequest();
        Assertions.assertNotNull((Object)request);
        Assertions.assertEquals((long)2L, (long)request.permits());
        Assertions.assertEquals((long)60L, (long)request.timeoutValue());
        Assertions.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)request.timeoutUnit()));
        DataCloudObjectModel objectModel = (DataCloudObjectModel)connectorModel.getObjects().get("WeatherStation");
        Assertions.assertNotNull((Object)objectModel);
        Map rateLimiterConfigs = objectModel.getResolvedByRateLimiterConfigs();
        Assertions.assertNotNull((Object)rateLimiterConfigs);
        Assertions.assertEquals((int)1, (int)rateLimiterConfigs.size());
        RateLimitConfigurationModel rateLimiterConfig = (RateLimitConfigurationModel)rateLimiterConfigs.get("stationRateLimit");
        Assertions.assertNotNull((Object)rateLimiterConfig);
        Assertions.assertTrue((boolean)rateLimiterConfig.isEnabled());
        Assertions.assertTrue((boolean)rateLimiterConfig.isTenantScoped());
        RateLimitConfigurationModel.RateModel stationRate = rateLimiterConfig.getRate();
        Assertions.assertNotNull((Object)stationRate);
        Assertions.assertEquals((long)1000L, (long)stationRate.value());
        Assertions.assertEquals((long)5000L, (long)stationRate.interval());
        Assertions.assertEquals((Object)RateIntervalUnit.SECONDS, (Object)stationRate.intervalUnit());
        Assertions.assertNull((Object)objectModel.getContentProviderRateLimiterConfigs());
        objectModel = (DataCloudObjectModel)connectorModel.getObjects().get("Measurement");
        Assertions.assertNotNull((Object)objectModel);
        rateLimiterConfigs = objectModel.getResolvedByRateLimiterConfigs();
        Assertions.assertNotNull((Object)rateLimiterConfigs);
        Assertions.assertEquals((int)1, (int)rateLimiterConfigs.size());
        rateLimiterConfig = (RateLimitConfigurationModel)rateLimiterConfigs.get("measurementRateLimit");
        Assertions.assertNotNull((Object)rateLimiterConfig);
        Assertions.assertTrue((boolean)rateLimiterConfig.isEnabled());
        Assertions.assertTrue((boolean)rateLimiterConfig.isTenantScoped());
        RateLimitConfigurationModel.RateModel measurementRate = rateLimiterConfig.getRate();
        Assertions.assertNotNull((Object)measurementRate);
        Assertions.assertEquals((long)500L, (long)measurementRate.value());
        Assertions.assertEquals((long)1L, (long)measurementRate.interval());
        Assertions.assertEquals((Object)RateIntervalUnit.MINUTES, (Object)measurementRate.intervalUnit());
        Assertions.assertNull((Object)objectModel.getContentProviderRateLimiterConfigs());
        objectModel = (DataCloudObjectModel)connectorModel.getObjects().get("Alert");
        Assertions.assertNotNull((Object)objectModel);
        rateLimiterConfigs = objectModel.getResolvedByRateLimiterConfigs();
        Assertions.assertNotNull((Object)rateLimiterConfigs);
        Assertions.assertEquals((int)1, (int)rateLimiterConfigs.size());
        rateLimiterConfig = (RateLimitConfigurationModel)rateLimiterConfigs.get("alertRateLimit");
        Assertions.assertNotNull((Object)rateLimiterConfig);
        Assertions.assertTrue((boolean)rateLimiterConfig.isEnabled());
        Assertions.assertTrue((boolean)rateLimiterConfig.isTenantScoped());
        RateLimitConfigurationModel.RateModel alertResolvedByRate = rateLimiterConfig.getRate();
        Assertions.assertNotNull((Object)alertResolvedByRate);
        Assertions.assertEquals((long)2000L, (long)alertResolvedByRate.value());
        Assertions.assertEquals((long)1L, (long)alertResolvedByRate.interval());
        Assertions.assertEquals((Object)RateIntervalUnit.HOURS, (Object)alertResolvedByRate.intervalUnit());
        rateLimiterConfigs = objectModel.getContentProviderRateLimiterConfigs();
        Assertions.assertNotNull((Object)rateLimiterConfigs);
        Assertions.assertEquals((int)1, (int)rateLimiterConfigs.size());
        rateLimiterConfig = (RateLimitConfigurationModel)rateLimiterConfigs.get("alertProviderRateLimit");
        Assertions.assertNotNull((Object)rateLimiterConfig);
        Assertions.assertTrue((boolean)rateLimiterConfig.isEnabled());
        Assertions.assertTrue((boolean)rateLimiterConfig.isTenantScoped());
        RateLimitConfigurationModel.RateModel alertContentProviderRate = rateLimiterConfig.getRate();
        Assertions.assertNotNull((Object)alertContentProviderRate);
        Assertions.assertEquals((long)500L, (long)alertContentProviderRate.value());
        Assertions.assertEquals((long)2L, (long)alertContentProviderRate.interval());
        Assertions.assertEquals((Object)RateIntervalUnit.HOURS, (Object)alertContentProviderRate.intervalUnit());
    }

    @Test
    void testNegativeRateValues() {
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.modelLoader.loadConnector("connectors::ratelimits::InvalidRates::connectorWithNegativeRate::connector"));
        Assertions.assertEquals(IllegalStateException.class, exception.getCause().getClass());
        Assertions.assertEquals((Object)"Rate configuration values must be positive numbers greater than 0", (Object)exception.getCause().getMessage());
    }

    @Test
    void testNegativeRequestValues() {
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.modelLoader.loadConnector("connectors::ratelimits::InvalidRequests::connectorWithNegativePermits::connector"));
        Assertions.assertEquals(IllegalStateException.class, exception.getCause().getClass());
        Assertions.assertEquals((Object)"Permits value must be a positive number greater than 0", (Object)exception.getCause().getMessage());
        exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.modelLoader.loadConnector("connectors::ratelimits::InvalidRequests::connectorWithNegativeTimeout::connector"));
        Assertions.assertEquals((Object)"Timeout value must be a positive number greater than 0", (Object)exception.getCause().getMessage());
    }

    @Test
    void testDefaultValuesWhenOptionalPropertiesAreMissing() {
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)this.modelLoader.loadConnector("connectors::ratelimits::DefaultValues::connectorWithMinimalConfig::connector");
        DataCloudConnectionModel connectionModel = (DataCloudConnectionModel)connectorModel.getConnections().get(0);
        Map rateLimitConfigurationModels = connectionModel.getRateLimitConfigurationModels();
        RateLimitConfigurationModel config = (RateLimitConfigurationModel)rateLimitConfigurationModels.get("minimal");
        Assertions.assertTrue((boolean)config.isEnabled());
        Assertions.assertTrue((boolean)config.isTenantScoped());
        RateLimitConfigurationModel.RequestModel request = config.getRequest();
        Assertions.assertNotNull((Object)request);
        Assertions.assertEquals((long)1L, (long)request.permits());
        Assertions.assertEquals((long)1L, (long)request.timeoutValue());
        Assertions.assertEquals((Object)((Object)TimeUnit.HOURS), (Object)((Object)request.timeoutUnit()));
    }

    @Test
    void testMissingRequiredProperties() {
        RuntimeException runtimeException = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.modelLoader.loadConnector("connectors::ratelimits::MissingProps::connectorWithoutRate::connector"));
        Assertions.assertEquals(InvalidConnectorException.class, runtimeException.getCause().getClass());
        Assertions.assertTrue((boolean)runtimeException.getCause().getMessage().contains("A required property 'rate' is missing."));
    }

    @Test
    void testIdProviderWithEmptyInputSelectors() {
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)this.modelLoader.loadConnector("connectors::ratelimits::EmptyValues::connectorWithEmptyInputSelectors::connector");
        DataCloudConnectionModel connectionModel = (DataCloudConnectionModel)connectorModel.getConnections().get(0);
        RateLimitConfigurationModel config = (RateLimitConfigurationModel)connectionModel.getRateLimitConfigurationModels().get("emptySelectors");
        Assertions.assertNull((Object)config.getIdProviderModel());
    }
}

