%dw 2.7
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::transport::Serialization
import * from com::mulesoft::connectivity::decorator::Operation

import DataCloudExtractAttribute from com::mulesoft::connectivity::datacloud::Metadata

type Types = {
  Error: {
    code: Number,
    message: String
  },
  Account: {
      sid?: String <~ {"description": "A 34 character string that uniquely identifies this resource."},
      date_created?: String <~ {"description": "The date that this account was created, in GMT in RFC 2822 format"},
      date_updated?: String <~ {"description": "The date that this account was last updated, in GMT in RFC 2822 format."},
      friendly_name?: String <~ {"description": "A human readable description of this account, up to 64 characters long. By default the FriendlyName is your email address."},
      owner_account_sid?: String <~ {"description": "The unique 34 character id that represents the parent of this account. The OwnerAccountSid of a parent account is it's own sid."},
      status?: String <~ {"description": "The status of this account. Usually `active`, but can be `suspended` or `closed`."},
      "type"?: String <~ {"description": "The type of this account. Either `Trial` or `Full` if it's been upgraded"},
      auth_token?: String <~ {"description": "The authorization token for this account. This token should be kept a secret, so no sharing"},
      subresource_uris?: {} <~ {"description": "A Map of various subresources available for the given Account Instance"},
      uri?: String <~ {"description": "The URI for this resource, relative to `https://api.twilio.com`"}
  },
  Message: {
      sid?: String <~ {"description": "The unique string that that we created to identify the Message resource."},
      body?: String <~ {"description": "The message text. Can be up to 1,600 characters long"},
      num_segments?: String <~ {"description": "The number of segments that make up the complete message. A message body that is too large to be sent in a single SMS message is segmented and charged as multiple messages. Inbound messages over 160 characters are reassembled when the message is received. Note: When using a Messaging Service to send messages, `num_segments` will always be 0 in Twilio''s response to your API request."},
      direction?: String <~ {"description": "The direction of the message. Can be: `inbound` for incoming messages, `outbound-api` for messages initiated by a REST API, `outbound-call` for messages initiated during a call, or `outbound-reply` for messages initiated in response to an incoming message."},
      from?: String <~ {"description": "The phone number (in [E.164](https://en.wikipedia.org/wiki/E.164) format), [alphanumeric sender ID](https://www.twilio.com/docs/sms/send-messages#use-an-alphanumeric-sender-id), or [Wireless SIM](https://www.twilio.com/docs/wireless/tutorials/communications-guides/how-to-send-and-receive-text-messages) that initiated the message. For incoming messages, this will be the number of the sending phone. For outgoing messages, this value will be one of your Twilio phone numbers or the alphanumeric sender ID used."},
      to?: String <~ {"description": "The phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format that received the message. For incoming messages, this will be one of your Twilio phone numbers. For outgoing messages, this will be the sending phone."},
      date_created?: String <~ {"description": "The date and time in GMT that the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format."},
      date_updated?: String <~ {"description": "The date and time in GMT that the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format."},
      date_sent?: String <~ {"description": "The date and time in GMT that the resource was sent specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format. For outgoing messages, this is when we sent the message. For incoming messages, this is when we made the HTTP request to your application."},
      price?: String <~ {"description": "The amount billed for the message, in the currency specified by `price_unit`.  Note that your account is charged for each segment we send to the handset. Populated after the message has been sent. May not be immediately available."},
      error_message?: String <~ {"description": "The description of the `error_code` if your message `status` is `failed` or `undelivered`. If the message was successful, this value is null."},
      account_sid?: String <~ {"description": "The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that sent the message that created the resource."},
      num_media?: String <~ {"description": "The number of media files associated with the message. A message can send up to 10 media files."},
      status?: String <~ {"description": "The status of the message. Can be: `accepted`, `scheduled`, `canceled`, `queued`, `sending`, `sent`, `failed`, `delivered`, `undelivered`, `receiving`, `received`, or `read` (WhatsApp only). For more information, See [detailed descriptions](https://www.twilio.com/docs/sms/api/message-resource#message-status-values)."},
      messaging_service_sid?: String <~ {"description": "The SID of the [Messaging Service](https://www.twilio.com/docs/sms/services/api) used with the message. The value is null if a Messaging Service was not used."},
      error_code?: Number <~ {"description": "The error code returned if your message `status` is `failed` or `undelivered`. The error_code provides more information about the failure. If the message was successful, this value is null."},
      price_unit?: String <~ {"description": "The currency in which `price` is measured, in [ISO 4127](https://www.iso.org/iso/home/standards/currency_codes.htm) format (e.g. `usd`, `eur`, `jpy`)."},
      api_version?: String <~ {"description": "The API version used to process the message."},
      uri?: String <~ {"description": "The URI of the resource, relative to `https://api.twilio.com`."},
      subresource_uris?: {} <~ {"description": "A list of related resources identified by their URIs relative to `https://api.twilio.com`"}
  }
}

type OperationTypes = {
  "/2010-04-01/Accounts.json": {
    get: {
      request: HttpRequestType<{|
        query: {
          tags?: Array<String>,
          limit?: Number
        },
        headers: Object,
        cookie: Object
      |}>,
      response: Array<Types.Account> | Types.Error,
      "200": Array<Types.Account>,
      "default": Types.Error
    }
  },
  "/2010-04-01/Accounts/{accountId}/Messages.json": {
      get: {
        request: HttpRequestType<{|
          uri: {
            accountId: String
          },
          query: {
            tags?: Array<String>,
            limit?: Number
          },
          headers: Object,
          cookie: Object
        |}>,
        response: Array<Types.Account> | Types.Error,
        "200": Array<Types.Account>,
        "default": Types.Error
      }
    }
}

type PaginatedOperationTypes = {
    "/2010-04-01/Accounts.json": {
        get: {
        // TODO (dcourtil) Review if needed
          tags?: Array<String>,
          limit?: Number,
          accountId?: @DataCloudExtractAttribute(value = "Account ID") String
        }
    },
    "/2010-04-01/Accounts/{accountId}/Messages.json": {
      get: {
        // TODO (dcourtil) Review -- Not sure why this cannot be required
        accountId?: @DataCloudExtractAttribute(value = "Account ID") String,
        messageId?: @DataCloudExtractAttribute(value = "Message ID") String,
        // TODO (dcourtil) Review if needed
        tags?: Array<String>,
        limit?: Number
      }
    }
}

var operations = {
  "/2010-04-01/Accounts.json": {
    get: {
      name: "getAccounts",
      displayName: "getAccounts",
      executor: (parameter: OperationTypes."/2010-04-01/Accounts.json".get.request, connection: HttpConnection): Result<HttpResponse<OperationTypes."/2010-04-01/Accounts.json".get."200">, ResultFailure<HttpResponse<OperationTypes."/2010-04-01/Accounts.json".get."default">, Error>> -> do {
        var query = parameter.query default {} withSerializationConfig {}
        var headers = serializeHeaders(parameter.headers default {}, {})
        var cookie = serializeCookies(parameter.cookie default {}, {})
        ---
        success(connection({
          method: "GET",
          path: "/2010-04-01/Accounts.json",
          queryParams: query,
          headers: headers,
          cookie: cookie,
          (body: parameter.body) if (parameter.body?)
        }) as HttpResponse<OperationTypes."/2010-04-01/Accounts.json".get."200">)
      }
    }
  },
  "/2010-04-01/Accounts/{accountId}/Messages.json": {
      get: {
        name: "getMessages",
        displayName: "getMessages",
        executor: (parameter: OperationTypes."/2010-04-01/Accounts/{accountId}/Messages.json".get.request, connection: HttpConnection): Result<HttpResponse<OperationTypes."/2010-04-01/Accounts/{accountId}/Messages.json".get."200">, ResultFailure<HttpResponse<OperationTypes."/2010-04-01/Accounts/{accountId}/Messages.json".get."default">, Error>> -> do {
          var query = parameter.query default {} withSerializationConfig {}
          var headers = serializeHeaders(parameter.headers default {}, {})
          var cookie = serializeCookies(parameter.cookie default {}, {})
          ---
          success(connection({
            method: "GET",
            path: "/2010-04-01/Accounts/$(parameter.uri.accountId!)/Messages.json",
            queryParams: query,
            headers: headers,
            cookie: cookie,
            (body: parameter.body) if (parameter.body?)
          }) as HttpResponse<OperationTypes."/2010-04-01/Accounts/{accountId}/Messages.json".get."200">)
        }
      }
  }
}

var paginatedOperations = {
    "/2010-04-01/Accounts.json": {
      get: (operations."/2010-04-01/Accounts.json".get paginated (param, pageValue) -> {
           items: (pageValue.body.accounts default []) as Array<Types.Account>,
           (nextPage: {
               args: param update {
                   case .query! -> parseQueryParameters(pageValue.body.next_page_uri default "")
               }
           }) if (!isEmpty(pageValue.body.accounts) and !isEmpty(pageValue.body.next_page_uri))
       }) mapInputOperation (param: PaginatedOperationTypes."/2010-04-01/Accounts.json".get) -> {
            query: {
                (tags: param.tags!) if (param.tags?),
                (limit: param.limit!) if (param.limit?)
            },
            headers: {},
            cookie: {}
        },
    },
    "/2010-04-01/Accounts/{accountId}/Messages.json": {
        get: (operations."/2010-04-01/Accounts/{accountId}/Messages.json".get paginated (param, pageValue) -> {
             items: (pageValue.body.messages default []) as Array<Types.Message>,
             (nextPage: {
                 args: param update {
                     case .query! -> parseQueryParameters(pageValue.body.next_page_uri default "")
                 }
             }) if (!isEmpty(pageValue.body.messages) and !isEmpty(pageValue.body.next_page_uri))
         }) mapInputOperation (param: PaginatedOperationTypes."/2010-04-01/Accounts/{accountId}/Messages.json".get) -> {
             uri:{
                (accountId: param.accountId!) if (param.accountId?),
             },
             query: {
                (tags: param.tags!) if (param.tags?),
                (limit: param.limit!) if (param.limit?)
             },
             headers: {},
             cookie: {}
         }
     }
}

@TestConnectionElement()
var testConnection: HttpTestConnection = {
  validate: (connection) -> {
    isValid: connection({
      method: "GET",
      path: "/testConnection",
      queryParams: {},
      headers: {},
      cookie: {}
    }).status == 200
  }
}

@ConnectionElement()
var mockConnectionProvider : HttpConnectionProvider<{||}, { "type": "custom" }> = {
    authenticationType: {"type": "custom" },
    connect: (parameter) -> (httpRequest: HttpRequester) -> do {
      var path = httpRequest.path
      var response = {contentType: "application/json", status: 200, headers: {}, cookies: {}}
      var accounts = [
          {
            sid: "1",
            friendly_name: "Z Company",
            subresource_uris: {
              messages: "/2010-04-01/Accounts/1/Messages.json"
            }
          },
          {
            id: "2",
            friendly_name: "X Company",
            subresource_uris: {
              messages: "/2010-04-01/Accounts/2/Messages.json"
            }
          }
        ]
      ---
      path match {
        case "/2010-04-01/Accounts.json" -> response ++ {body: accounts}
        else -> response
      }
    }
}
