%dw 2.7
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::transport::Serialization
import * from com::mulesoft::connectivity::decorator::Operation
import Description, Hidden from com::mulesoft::connectivity::decorator::Annotations
import DataCloudExtractAttribute, Masked from com::mulesoft::connectivity::datacloud::Metadata

type Types = {
  Error: {
    code: Number,
    message: String
  },
  Account: {
      sid?: @Description(value = "A 34 character string that uniquely identifies this resource.") String
  }
}

type OperationTypes = {
  "/2010-04-01/Accounts.json": {
    get: {
      request: HttpRequestType<{|
        query: {
          tags?: Array<String>,
          limit?: Number
        },
        headers: Object,
        cookie: Object
      |}>,
      response: Array<Types.Account> | Types.Error,
      "200": Array<Types.Account>,
      "default": Types.Error
    }
  }
}

type PaginatedOperationTypes = {
    "/2010-04-01/Accounts.json": {
        get: {
          tags?: Array<String>,
          limit?: Number,
          // Test ObjectMetadataValue form with custom selector name
          accountSid?: @DataCloudExtractAttribute(value = {label: "Account ID", selectorName: "accountId"}) String,
          // Test hidden attribute
          apiKey?: @DataCloudExtractAttribute(value = "API Key") @Hidden() String,
          // Test masked attribute
          password?: @DataCloudExtractAttribute(value = "Password") @Masked() String,
          // Test includeKeyName feature
          orgIdentifier?: @DataCloudExtractAttribute(value = {label: "Organization ID", selectorName: "orgId", includeKeyName: "true"}) String
        }
    }
}

var operations = {
  "/2010-04-01/Accounts.json": {
    get: {
      name: "getAccounts",
      displayName: "getAccounts",
      executor: (parameter: OperationTypes."/2010-04-01/Accounts.json".get.request, connection: HttpConnection): Result<HttpResponse<OperationTypes."/2010-04-01/Accounts.json".get."200">, ResultFailure<HttpResponse<OperationTypes."/2010-04-01/Accounts.json".get."default">, Error>> -> do {
        var query = parameter.query default {} withSerializationConfig {}
        var headers = serializeHeaders(parameter.headers default {}, {})
        var cookie = serializeCookies(parameter.cookie default {}, {})
        ---
        success(connection({
          method: "GET",
          path: "/2010-04-01/Accounts.json",
          queryParams: query,
          headers: headers,
          cookie: cookie,
          (body: parameter.body) if (parameter.body?)
        }) as HttpResponse<OperationTypes."/2010-04-01/Accounts.json".get."200">)
      }
    }
  }
}

var paginatedOperations = {
    "/2010-04-01/Accounts.json": {
      get: (operations."/2010-04-01/Accounts.json".get paginated (param, pageValue) -> {
           items: (pageValue.body.accounts default []) as Array<Types.Account>,
           (nextPage: {
               args: param update {
                   case .query! -> parseQueryParameters(pageValue.body.next_page_uri default "")
               }
           }) if (!isEmpty(pageValue.body.accounts) and !isEmpty(pageValue.body.next_page_uri))
       }) mapInputOperation (param: PaginatedOperationTypes."/2010-04-01/Accounts.json".get) -> {
            query: {
                (tags: param.tags!) if (param.tags?),
                (limit: param.limit!) if (param.limit?)
            },
            headers: {},
            cookie: {}
        }
    }
}

@TestConnectionElement()
var testConnection: HttpTestConnection = {
  validate: (connection) -> {
    isValid: connection({
      method: "GET",
      path: "/testConnection",
      queryParams: {},
      headers: {},
      cookie: {}
    }).status == 200
  }
}

@ConnectionElement()
var mockConnectionProvider : HttpConnectionProvider<{||}, { "type": "custom" }> = {
    authenticationType: {"type": "custom" },
    connect: (parameter) -> (httpRequest: HttpRequester) -> do {
      var path = httpRequest.path
      var response = {contentType: "application/json", status: 200, headers: {}, cookies: {}}
      var accounts = [
          {
            sid: "1",
            friendly_name: "Z Company"
          }
        ]
      ---
      path match {
        case "/2010-04-01/Accounts.json" -> response ++ {body: accounts}
        else -> response
      }
    }
}
