%dw 2.7
import * from com::mulesoft::connectivity::datacloud::Metadata
import * from connectors::twilio::Variants::Module

var accountObject = {
    name: "Account",
    resolvedBy: paginatedOperations."/2010-04-01/Accounts.json".get
}

var messageObject = {
    name: "Message",
    resolvedBy: paginatedOperations."/2010-04-01/Accounts/{accountId}/Messages.json".get,
    dependsOn: {
        object: accountObject,
        binding: (account) -> { accountId: account.sid }
    }
}

@DataCloudConnectorElement()
var connector = {
  name: "Twilio Connector",
  label: "Twilio Connector",
  description: "Description for Twilio Connector",
  displayName: "Twilio Connector",
  releaseLevel: "IN_DEV",
  features: ["INGRESS","OBJECTBASED"],
  connection:  mockConnectionProvider,
  testConnection: testConnection,
  version: "0.0.1",
  ingressDescription: "Twilio Connector",
  vendor: "Mulesoft",
  objects: {
       account: accountObject,
       message: messageObject
    }
}
