/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.api.loader;

import com.mulesoft.connectivity.datacloud.api.loader.DataCloudModelLoaderFactory;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectorModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudObjectModel;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ModuleComponentsFactory;
import org.mule.weave.v2.runtime.SimpleModuleComponentFactory;

class DataCloudObjectsLoaderTest {
    DataCloudObjectsLoaderTest() {
    }

    @ParameterizedTest
    @CsvSource(value={"basicconnector::Connector::connector, 3", "objectVariants::Connector_1::connector, 1", "objectVariants::Connector_2::connector, 1", "objectVariants::Connector_3::connector, 1"})
    void objectReferencesTest(String connectorRelativeLocation, String expectedObjectCount) {
        DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)modelLoader.loadConnector("connectors::" + connectorRelativeLocation);
        Assertions.assertEquals((Integer)Integer.valueOf(expectedObjectCount), (int)connectorModel.getObjects().size());
    }

    @Test
    void objectReferencingOperationWithNonObjectResultType() {
        DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
        RuntimeException runtimeException = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> modelLoader.loadConnector("connectors::objectVariants::Connector_4::connector"));
        Assertions.assertEquals(IllegalStateException.class, runtimeException.getCause().getClass());
        Assertions.assertEquals((Object)"Invalid weave type: expected Object but Array<String> found", (Object)runtimeException.getCause().getMessage());
    }

    @Test
    void objectReferencingOperationWithMultipleSuccessResultTypes() {
        DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)modelLoader.loadConnector("connectors::objectVariants::Connector_5::connector");
        Assertions.assertEquals((int)1, (int)connectorModel.getObjects().size());
        Assertions.assertNotNull(connectorModel.getObjects().get("MedicalRecord"));
    }

    @Test
    void objectReferencingOperationWithAnyResultType() {
        DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
        RuntimeException runtimeException = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> modelLoader.loadConnector("connectors::objectVariants::Connector_6::connector"));
        Assertions.assertEquals(IllegalStateException.class, runtimeException.getCause().getClass());
        Assertions.assertEquals((Object)"Unsupported operation return type: `AnyType`", (Object)runtimeException.getCause().getMessage());
    }

    @Test
    void objectReferencingSimpleTriggerTest() {
        DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)modelLoader.loadConnector("connectors::triggers::Connector::connector");
        Assertions.assertEquals((int)1, (int)connectorModel.getObjects().size());
    }

    @Test
    void objectDependencyOnNonExposedObject() {
        DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> modelLoader.loadConnector("connectors::invalid::MissingDependentConnector::connector"));
        Assertions.assertEquals((Object)"Object 'Accessory' depends on object 'Pet', which is not listed as a connector object", (Object)exception.getCause().getMessage());
    }

    @Test
    void objectReferencingContentProviderTest() {
        DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)modelLoader.loadConnector("connectors::unstructured::Connector::connector");
        Assertions.assertEquals((int)1, (int)connectorModel.getObjects().size());
        Assertions.assertNotNull((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Cars")).getContentProvider());
    }

    @Test
    void objectReferencingContentProviderInvalidTest() {
        DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
        Exception exception = (Exception)Assertions.assertThrows(RuntimeException.class, () -> modelLoader.loadConnector("connectors::unstructured::connectorVariants::Connector::connector"));
        Assertions.assertInstanceOf(IllegalStateException.class, (Object)exception.getCause());
        Assertions.assertTrue((boolean)exception.getCause().getMessage().contains("Content provider input fields are not present in result output fields."));
    }

    @Test
    void objectReferencingNestedContentProviderValidTest() {
        DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)modelLoader.loadConnector("connectors::unstructured::connectorVariants::Connector_2::connector");
        Assertions.assertEquals((int)1, (int)connectorModel.getObjects().size());
        Assertions.assertNotNull((Object)((DataCloudObjectModel)connectorModel.getObjects().get("Cars")).getContentProvider());
    }

    @Test
    void objectReferencingNestedContentProviderInvalidTest() {
        DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
        Exception exception = (Exception)Assertions.assertThrows(RuntimeException.class, () -> modelLoader.loadConnector("connectors::unstructured::connectorVariants::Connector_3::connector"));
        Assertions.assertInstanceOf(IllegalStateException.class, (Object)exception.getCause());
        Assertions.assertTrue((boolean)exception.getCause().getMessage().contains("Content provider input fields are not present in result output fields."));
    }

    @Test
    void objectReferencingContentProviderInvalidReturnTypeTest() {
        DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
        Exception exception = (Exception)Assertions.assertThrows(RuntimeException.class, () -> modelLoader.loadConnector("connectors::unstructured::connectorVariants::Connector_1::connector"));
        Assertions.assertInstanceOf(IllegalStateException.class, (Object)exception.getCause());
        Assertions.assertEquals((Object)"ContentProvider should return Binary type only", (Object)exception.getCause().getMessage());
    }

    @Test
    void objectReferencingHiddenObjectTest() {
        DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)modelLoader.loadConnector("connectors::objectVariants::Connector_HiddenObject::connector");
        Assertions.assertEquals((int)3, (int)connectorModel.getObjects().size());
        Assertions.assertTrue((boolean)((DataCloudObjectModel)connectorModel.getObjects().get("Accessory")).isHidden());
    }

    @Test
    void objectReferencingCorrectConnectionModel() {
        DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
        LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
        DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)modelLoader.loadConnector("connectors::weather::Connector::connector");
        Assertions.assertEquals((int)3, (int)connectorModel.getObjects().size());
        DataCloudObjectModel objectModel = (DataCloudObjectModel)connectorModel.getObjects().get("CurrentWeather");
        Assertions.assertNotNull((Object)objectModel);
        DataCloudConnectionModel connectionModel = objectModel.getConnectionModel();
        Assertions.assertNotNull((Object)connectionModel);
        Assertions.assertEquals((Object)"basicAuth", (Object)connectionModel.getName());
        objectModel = (DataCloudObjectModel)connectorModel.getObjects().get("Forecast");
        Assertions.assertNotNull((Object)objectModel);
        connectionModel = objectModel.getConnectionModel();
        Assertions.assertNotNull((Object)connectionModel);
        Assertions.assertEquals((Object)"restApiAuth", (Object)connectionModel.getName());
        objectModel = (DataCloudObjectModel)connectorModel.getObjects().get("Alert");
        Assertions.assertNotNull((Object)objectModel);
        connectionModel = objectModel.getConnectionModel();
        Assertions.assertNotNull((Object)connectionModel);
        Assertions.assertEquals((Object)"graphApiAuth", (Object)connectionModel.getName());
    }
}

