/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.api.loader;

import com.mulesoft.connectivity.datacloud.api.loader.DataCloudRateLimiterConfigurationLoader;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudObjectModel;
import com.mulesoft.connectivity.datacloud.api.model.RateLimitConfigurationModel;
import com.mulesoft.connectivity.linkweave.api.DataWeaveObjectReference;
import com.mulesoft.connectivity.linkweave.api.DataWeaveReference;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.loader.WeaveTypeSimplifier;
import com.mulesoft.connectivity.linkweave.api.loader.impl.OperationLoaderImpl;
import com.mulesoft.connectivity.linkweave.api.loader.impl.TriggerLoaderImpl;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.salesforce.dataconnectors.api.model.metadata.ObjectType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.AnyType;
import org.mule.weave.v2.api.tooling.ts.ArrayType;
import org.mule.weave.v2.api.tooling.ts.BinaryType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.FunctionType;
import org.mule.weave.v2.api.tooling.ts.KeyType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.NameType;
import org.mule.weave.v2.api.tooling.ts.UnionType;

public class DataCloudObjectsLoader
extends ModelLoader<DataCloudObjectModel, DataCloudObjectModel.Builder, DataWeaveObjectReference> {
    private final OperationLoaderImpl operationLoader;
    private final TriggerLoaderImpl triggerLoader;
    private final DataCloudRateLimiterConfigurationLoader rateLimiterConfigurationLoader;
    private Map<String, RateLimitConfigurationModel> rateLimitConfigurationModels;
    private List<DataCloudConnectionModel> connections;

    public DataCloudObjectsLoader(OperationLoaderImpl operationLoader, TriggerLoaderImpl triggerLoader, DataCloudRateLimiterConfigurationLoader rateLimiterConfigurationLoader) {
        this.operationLoader = operationLoader;
        this.triggerLoader = triggerLoader;
        this.rateLimiterConfigurationLoader = rateLimiterConfigurationLoader;
        this.rateLimitConfigurationModels = new HashMap<String, RateLimitConfigurationModel>();
        this.connections = new ArrayList<DataCloudConnectionModel>();
    }

    public void setConnections(List<DataCloudConnectionModel> connections) {
        this.connections = connections;
    }

    protected DataCloudObjectModel.Builder createBuilder() {
        return new DataCloudObjectModel.Builder();
    }

    protected DataCloudObjectModel.Builder configureBuilder(DataCloudObjectModel.Builder builder, DataWeaveObjectReference object, @Nullable String name) {
        DWType objectMetadataType;
        DataWeaveReference operationRef;
        ExecutableComponentModel resolvedBy;
        String objectName = object.requireProperty("name").asString();
        builder.withName(objectName);
        builder.withType(object.getProperty("type").map(DataWeaveReference::asString).orElse(ObjectType.UNSTRUCTURED_DATA.getValue()));
        builder.withIsHidden(object.getProperty("isHidden").map(DataWeaveReference::asBoolean).orElse(false));
        builder.withCustomHandler(object.getProperty("customHandler").map(DataWeaveReference::asString).orElse(null));
        DataWeaveObjectReference resolverRef = object.requireObjectProperty("resolvedBy");
        if (resolverRef.getProperty("executor").isPresent()) {
            resolvedBy = (ExecutableComponentModel)this.operationLoader.loadModel((DataWeaveReference)resolverRef, null);
            operationRef = resolverRef.requireProperty("executor");
        } else {
            resolvedBy = (ExecutableComponentModel)this.triggerLoader.loadModel((DataWeaveReference)resolverRef, null);
            operationRef = resolverRef.requireObjectProperty("operation").requireProperty("executor");
        }
        builder.withResolvedBy(resolvedBy);
        DataCloudObjectsLoader.validateTypeOf(operationRef.getType(), FunctionType.class, "executor");
        FunctionType operationType = (FunctionType)operationRef.getType();
        DWType resolvedReturnType = TypeUtils.resolveReferenceType((DWType)operationType.getReturnType());
        DataCloudObjectsLoader.validateTypeOf(resolvedReturnType, UnionType.class, "operation return type");
        UnionType operationReturnType = (UnionType)resolvedReturnType;
        DWType[] operationReturnTypeVariants = operationReturnType.unionOf();
        DWType successType = TypeUtils.resolveReferenceType((DWType)operationReturnTypeVariants[0]);
        if (successType instanceof UnionType) {
            successType = WeaveTypeSimplifier.simplifyWeaveType((DWType)successType);
        }
        DataCloudObjectsLoader.validateTypeOf(successType, org.mule.weave.v2.api.tooling.ts.ObjectType.class, "operation return type");
        org.mule.weave.v2.api.tooling.ts.ObjectType operationReturnTypeSuccessVariant = (org.mule.weave.v2.api.tooling.ts.ObjectType)successType;
        KeyValuePairType[] successVariantProperties = operationReturnTypeSuccessVariant.getProperties();
        DWType successValueType = TypeUtils.resolveReferenceType((DWType)successVariantProperties[1].getValue());
        if (successValueType instanceof UnionType) {
            UnionType successUnionType = (UnionType)successValueType;
            successValueType = successUnionType.unionOf()[0];
        }
        DWType resolvedSuccessValueType = TypeUtils.resolveReferenceType((DWType)successValueType);
        DataCloudObjectsLoader.validateTypeOf(resolvedSuccessValueType, org.mule.weave.v2.api.tooling.ts.ObjectType.class, "operation return type");
        org.mule.weave.v2.api.tooling.ts.ObjectType resultType = (org.mule.weave.v2.api.tooling.ts.ObjectType)resolvedSuccessValueType;
        if (resolvedBy.isPaginated()) {
            KeyValuePairType pageItems = Stream.of(resultType.getProperties()).filter(p -> {
                KeyType key = (KeyType)p.getKey();
                NameType keyName = (NameType)key.getName();
                Optional maybeQName = keyName.getValue();
                return maybeQName.filter(qname -> "items".equals(qname.getName())).isPresent();
            }).findFirst().orElseThrow(() -> new IllegalStateException("Items field was not found in paginated response"));
            objectMetadataType = TypeUtils.resolveReferenceType((DWType)((ArrayType)pageItems.getValue()).arrayOf());
        } else {
            Optional<KeyValuePairType> maybeHttpResultBody = Stream.of(resultType.getProperties()).filter(p -> {
                KeyType key = (KeyType)p.getKey();
                NameType keyName = (NameType)key.getName();
                Optional maybeQName = keyName.getValue();
                return maybeQName.filter(qname -> "body".equals(qname.getName())).isPresent();
            }).findFirst();
            if (maybeHttpResultBody.isPresent()) {
                DWType valueType = maybeHttpResultBody.get().getValue();
                objectMetadataType = TypeUtils.resolveReferenceType((DWType)valueType);
                if (objectMetadataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)objectMetadataType;
                    objectMetadataType = TypeUtils.resolveReferenceType((DWType)arrayType.arrayOf());
                }
            } else {
                objectMetadataType = TypeUtils.resolveReferenceType((DWType)resultType);
            }
        }
        if (objectMetadataType instanceof AnyType) {
            throw new IllegalStateException("Unsupported operation return type: `AnyType`");
        }
        DWType dataType = WeaveTypeSimplifier.simplifyWeaveType((DWType)objectMetadataType);
        if (!(dataType instanceof org.mule.weave.v2.api.tooling.ts.ObjectType)) {
            throw new IllegalStateException("Unsupported operation return type, expecting `ObjectType`");
        }
        org.mule.weave.v2.api.tooling.ts.ObjectType objectDataType = (org.mule.weave.v2.api.tooling.ts.ObjectType)dataType;
        builder.withMetadataType((TypeModel)new TypeModel.Builder().withDataType((DWType)objectDataType).build());
        resolverRef.getObjectProperty("rateLimiterConfigs").ifPresent(ref -> {
            Map<String, RateLimitConfigurationModel> configs = ref.properties().map(p -> (RateLimitConfigurationModel)this.rateLimiterConfigurationLoader.loadModel((DataWeaveReference)((DataWeaveReference)p.getValue()).asObjectReference(), (String)p.getKey())).collect(Collectors.toMap(RateLimitConfigurationModel::getId, Function.identity()));
            builder.withResolvedByRateLimiterConfigs(configs);
            this.rateLimitConfigurationModels.putAll(configs);
        });
        Optional dependsOn = object.getObjectProperty("dependsOn");
        dependsOn.ifPresent(dep -> builder.withDependencyBinding((Function)dep.requireProperty("binding").getValue()));
        dependsOn.ifPresent(dep -> dep.getProperty("when").ifPresent(e -> builder.withDependencyConditional((Function)e.getValue())));
        Optional contentProvider = object.getObjectProperty("contentProvider");
        contentProvider.ifPresent(provider -> {
            OperationModel contentProviderModel = (OperationModel)this.operationLoader.loadModel((DataWeaveReference)provider, null);
            List contentProviderInput = Arrays.stream(((org.mule.weave.v2.api.tooling.ts.ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)contentProviderModel.getInputType().getDataType())).getProperties()).map(KeyValuePairType::getKeyName).collect(Collectors.toList());
            List<String> resultOutputFields = Arrays.stream(((org.mule.weave.v2.api.tooling.ts.ObjectType)dataType).getProperties()).map(KeyValuePairType::getKeyName).toList();
            if (!new HashSet<String>(resultOutputFields).containsAll(contentProviderInput = contentProviderInput.stream().map(element -> element.split("\\.")[0]).map(fieldName -> fieldName.replaceAll("^\"|\"$", "")).collect(Collectors.toList()))) {
                contentProviderInput.removeAll(resultOutputFields);
                throw new IllegalStateException("Content provider input fields are not present in result output fields. Content provider input fields: " + String.valueOf(contentProviderInput) + " is not present in return type of resolvedBy. Allowed values: " + String.valueOf(resultOutputFields));
            }
            DWType simplifiedOutputType = WeaveTypeSimplifier.simplifyWeaveType((DWType)contentProviderModel.getOutputType().getDataType());
            if (simplifiedOutputType instanceof org.mule.weave.v2.api.tooling.ts.ObjectType) {
                org.mule.weave.v2.api.tooling.ts.ObjectType outputType = (org.mule.weave.v2.api.tooling.ts.ObjectType)simplifiedOutputType;
                simplifiedOutputType = Arrays.stream(outputType.getProperties()).filter(p -> p.getKeyName().equalsIgnoreCase("body")).findFirst().map(KeyValuePairType::getValue).orElseThrow(() -> new IllegalStateException("ContentProvider result don't have body field"));
            }
            if (!(simplifiedOutputType instanceof BinaryType)) {
                throw new IllegalStateException("ContentProvider should return Binary type only");
            }
            builder.withContentProvider((ExecutableComponentModel<?>)contentProviderModel);
            provider.getObjectProperty("rateLimiterConfigs").ifPresent(ref -> {
                Map<String, RateLimitConfigurationModel> configs = ref.properties().map(p -> (RateLimitConfigurationModel)this.rateLimiterConfigurationLoader.loadModel((DataWeaveReference)((DataWeaveReference)p.getValue()).asObjectReference(), (String)p.getKey())).collect(Collectors.toMap(RateLimitConfigurationModel::getId, Function.identity()));
                builder.withContentProviderRateLimiterConfigs(configs);
                this.rateLimitConfigurationModels.putAll(configs);
            });
        });
        Optional navigableContainer = object.getObjectProperty("navigableContainer");
        navigableContainer.ifPresent(container -> {
            builder.withIsContainer((Function)container.requireProperty("isContainer").getValue());
            builder.withContainerBinding((Function)container.requireProperty("binding").getValue());
            builder.withDoProcessContainer(container.getProperty("doProcess").map(DataWeaveReference::asBoolean).orElse(false));
        });
        object.getProperty("connection").map(connection -> {
            String connectionName = connection.asString();
            return this.connections.stream().filter(p -> connectionName.equals(p.getName())).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find referenced connection with name " + connectionName));
        }).ifPresentOrElse(builder::withConnection, () -> builder.withConnection(this.connections.get(0)));
        return builder;
    }

    private static void validateTypeOf(DWType type, Class<?> expected, String validatedElement) {
        if (!expected.isAssignableFrom(type.getClass())) {
            throw new IllegalStateException("Expected `" + expected.getSimpleName() + "` type for " + validatedElement + ", but found `" + String.valueOf(type) + "`");
        }
    }

    @Generated
    public Map<String, RateLimitConfigurationModel> getRateLimitConfigurationModels() {
        return this.rateLimitConfigurationModels;
    }
}

