/*
 * Copyright (c) 2025, Salesforce, Inc.,
 * All rights reserved.
 * For full license text, see the LICENSE.txt file
 */
%dw 2.7

import SemanticTerm from com::mulesoft::connectivity::decorator::Annotations

/**
* Annotates the variable that should be used as the connector description.
*/
@AnnotationTarget(targets = ["Variable"])
annotation DataCloudConnectorElement()

@AnnotationTarget(targets = ["KeyType", "Type", "TypeExpression"])
@Metadata(key = "DataCloudExtractAttribute")
annotation DataCloudExtractAttribute(value: String)

@AnnotationTarget(targets = ["KeyType", "Type", "TypeExpression"])
@Metadata(key = "Ignore")
annotation Ignore(value: {} = {})

@AnnotationTarget(targets = ["KeyType", "Type", "TypeExpression"])
@Metadata(key = "Secure")
annotation Secure(value: {} = {})

/**
 * Describes the role a given value has, allowing to classify it as sensitive
 * if necessary.
 */
@AnnotationTarget(targets = ["KeyType", "Type", "TypeExpression"])
@Metadata(key = "dataCloudSemanticTerms")
annotation DataCloudSemanticTerms(value: Array<DataCloudSemanticTerm>)

/**
 * Possible roles for a given value.
 */
type DataCloudSemanticTerm = SemanticTerm | "primaryKey" | "passwordFile" | "incrementalSyncKey" | "lastModifiedTime" | "size" | "filename" | "mimeType"
