/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.dc.maven.api.mojo;

import com.mulesoft.connectivity.maven.api.mojo.AbstractConnectivityMojo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

public abstract class AbstractDataCloudMojo
extends AbstractConnectivityMojo {
    protected static final String DESCRIPTOR_BASE_PATH = "com/mulesoft/connectivity/datacloud/connector/";
    protected static final String ICON_PATH_FORMAT = "ConnectionDefinition/%s.svg";
    protected static final String DESCRIPTOR_LOCATOR = "com/mulesoft/connectivity/datacloud/connector/MSDCConnector.info";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getConnectorLocator() {
        Iterable connectorDescriptors;
        try {
            connectorDescriptors = Thread.currentThread().getContextClassLoader().getResources(DESCRIPTOR_LOCATOR)::asIterator;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to find any descriptor", e);
        }
        if (!connectorDescriptors.iterator().hasNext()) throw new IllegalArgumentException(String.format("Failed to find a connector reference in \"%s\", expected at least one connector reference in file.", DESCRIPTOR_LOCATOR));
        URL descriptorUrl = (URL)connectorDescriptors.iterator().next();
        try (InputStream descriptorContents = descriptorUrl.openConnection().getInputStream();){
            if (descriptorContents == null) {
                throw new RuntimeException(String.format("Failed to open descriptor at %s", descriptorUrl));
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(descriptorContents));
            while (reader.ready()) {
                String connectorReference = reader.readLine();
                if (connectorReference == null || connectorReference.startsWith("#") || connectorReference.isBlank()) continue;
                String string = connectorReference;
                return string;
            }
            throw new IllegalArgumentException(String.format("Failed to find a connector reference in \"%s\", expected at least one connector reference in file.", DESCRIPTOR_LOCATOR));
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("Failed to load connector locator file from %s", descriptorUrl), ex);
        }
    }
}

