/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.dc.maven.api.mojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.mulesoft.connectivity.datacloud.api.loader.DataCloudModelLoaderFactory;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectorModel;
import com.mulesoft.connectivity.datacloud.api.utils.DataCloudMetadataHelper;
import com.mulesoft.connectivity.dc.maven.api.mojo.AbstractDataCloudMojo;
import com.mulesoft.connectivity.dc.maven.internal.utils.ConnectionDefinitionTransformer;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.maven.api.model.Phase;
import com.mulesoft.connectivity.maven.api.model.Status;
import com.salesforce.dataconnectors.api.model.connection.Attribute;
import com.salesforce.dataconnectors.api.model.connection.ConnectionDefinition;
import com.salesforce.dataconnectors.api.model.execution.ExtractAttributes;
import com.salesforce.dataconnectors.api.model.metadata.ConnectorMetadata;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jspecify.annotations.NullMarked;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ModuleComponentsFactory;
import org.mule.weave.v2.runtime.SimpleModuleComponentFactory;

@NullMarked
@Mojo(name="buildDefinitionFiles", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE, threadSafe=true)
public class BuildDefinitionFilesMojo
extends AbstractDataCloudMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/classes/com/mulesoft/connectivity/datacloud/connector/")
    private String outputDirectory;
    @Parameter(property="connectionFileName", defaultValue="ConnectionDefinition.json")
    private String connectionFileName;
    @Parameter(property="attributesFileName", defaultValue="ExtractAttributes.json")
    private String attributesFileName;

    public void execute() throws MojoExecutionException {
        try {
            BuildDefinitionFilesMojo.withContextClassLoader((ClassLoader)this.getCustomClassLoader(), () -> {
                DataWeaveScriptingEngine dataWeaveScriptingEngine = DataWeaveScriptingEngine.apply((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
                LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveScriptingEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
                DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)modelLoader.loadConnector(this.getConnectorLocator());
                ConnectionDefinition connectionDefinition = new ConnectionDefinitionTransformer(connectorModel).getConnectionDefinition();
                Path connectionDefinitionfilePath = Path.of(this.outputDirectory, connectorModel.getName().toLowerCase()).resolve(this.connectionFileName);
                BuildDefinitionFilesMojo.writeDefinitionToFile(connectionDefinition, connectionDefinitionfilePath);
                List extractAttributes = DataCloudMetadataHelper.getExtractAttributes((DataCloudConnectorModel)connectorModel);
                Path extractAttrFilePath = Path.of(this.outputDirectory, connectorModel.getName().toLowerCase()).resolve(this.attributesFileName);
                BuildDefinitionFilesMojo.writeDefinitionToFile(ExtractAttributes.builder().extractAttributes(extractAttributes).build(), extractAttrFilePath);
                BuildDefinitionFilesMojo.validateGeneratedConnectionDefinition(connectorModel, connectionDefinition, extractAttributes);
                this.writeMojoResult(Phase.PACKAGE, Status.SUCCESS);
                return null;
            });
        }
        catch (Exception ex) {
            this.writeMojoResult(Phase.PACKAGE, Status.FAILURE, ex.getCause(), Collections.emptyMap());
            throw new MojoExecutionException("Failed to generate the ConnectionDefinition.json file: " + ex.getMessage(), ex);
        }
    }

    private static void validateGeneratedConnectionDefinition(DataCloudConnectorModel connectorModel, ConnectionDefinition connectionDefinition, List<Attribute> extractAttributes) {
        new ConnectorMetadata(connectorModel.getName(), "/cdp/images/connectors/" + connectorModel.getName() + ".svg", connectionDefinition, ExtractAttributes.builder().extractAttributes(extractAttributes).build());
    }

    private static <T> void writeDefinitionToFile(T data, Path filePath) throws MojoExecutionException {
        ObjectMapper objectMapper = BuildDefinitionFilesMojo.createObjectMapper();
        try {
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("There was an error while creating parent directories of %s", filePath), (Exception)e);
        }
        try (FileWriter writer = new FileWriter(filePath.toString());){
            objectMapper.writeValue((Writer)writer, data);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("There was an error while writing to %s", filePath), (Exception)e);
        }
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return objectMapper;
    }
}

