/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.dc.maven.internal.utils;

import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionProviderModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectorModel;
import com.mulesoft.connectivity.datacloud.api.utils.DataCloudMetadataHelper;
import com.mulesoft.connectivity.linkweave.api.loader.WeaveTypeSimplifier;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataValueUtils;
import com.mulesoft.connectivity.linkweave.api.model.MetadataKey;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2AuthenticationType;
import com.salesforce.dataconnectors.api.model.connection.Attribute;
import com.salesforce.dataconnectors.api.model.connection.ConnectionDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.ArrayMetadataValue;
import org.mule.weave.v2.api.tooling.ts.DWMetadata;
import org.mule.weave.v2.api.tooling.ts.DWMetadataValue;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;

@NullMarked
public class ConnectionDefinitionTransformer {
    private static final Set<String> SUPPORTED_STANDARD_ATTRIBUTES = Set.of("username", "password");
    private static final String NAMED_CREDENTIAL_STANDARD_ATTRIBUTE = "namedCredential";
    private final DataCloudConnectorModel connectorModel;

    public ConnectionDefinitionTransformer(DataCloudConnectorModel connectorModel) {
        this.connectorModel = connectorModel;
    }

    public ConnectionDefinition getConnectionDefinition() {
        ConnectionDefinition.ConnectionDefinitionBuilder builder = ConnectionDefinition.builder().name(this.connectorModel.getName()).label(this.connectorModel.getLabel()).releaseLevel(this.connectorModel.getReleaseLevel()).features(this.connectorModel.getFeatures()).accessCheck(this.connectorModel.getAccessCheck()).featuresConfig(this.connectorModel.getFeaturesConfig()).customErrorLabels(this.connectorModel.getCustomErrorLabels()).connectionAttributes(this.getConnectionAttributes(this.connectorModel));
        if (this.connectorModel.getIngressDescription().isBlank() && (this.connectorModel.getEgressDescription() == null || this.connectorModel.getEgressDescription().isBlank())) {
            builder.description(this.connectorModel.getDescription());
        } else {
            builder.ingressDescription(this.connectorModel.getIngressDescription()).egressDescription(this.connectorModel.getEgressDescription());
        }
        return builder.build();
    }

    private List<Attribute> getConnectionAttributes(DataCloudConnectorModel connectorModel) {
        if (connectorModel.getConnections().isEmpty()) {
            throw new IllegalStateException("DC Connectors should have at least one connection.");
        }
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        for (DataCloudConnectionModel connectionModel : connectorModel.getConnections()) {
            if (connectionModel.getConnectionProviderModel() == null) {
                throw new IllegalStateException("DC Connector's connection provider model should not be null.");
            }
            ObjectType inputType = ConnectionDefinitionTransformer.getObjectType(connectionModel);
            if (inputType.getProperties() == null) {
                return result;
            }
            for (KeyValuePairType field : inputType.getProperties()) {
                Attribute attribute;
                if (this.isIgnoredField(field)) continue;
                AuthenticationType authType = connectionModel.getConnectionProviderModel().getAuthenticationType();
                if (authType instanceof OAuth2AuthenticationType && DataCloudMetadataHelper.hasSemanticTerm((KeyValuePairType)field, (String)"secretToken")) {
                    attribute = Attribute.builder().name(NAMED_CREDENTIAL_STANDARD_ATTRIBUTE).type(NAMED_CREDENTIAL_STANDARD_ATTRIBUTE).build();
                } else if (!(authType instanceof OAuth2AuthenticationType) && this.isStandardAttribute(field)) {
                    String standardAttribute = SUPPORTED_STANDARD_ATTRIBUTES.stream().filter(a -> DataCloudMetadataHelper.hasSemanticTerm((KeyValuePairType)field, (String)a)).findFirst().orElseThrow(() -> new IllegalStateException("No semantic term was found"));
                    attribute = Attribute.builder().name(field.getKeyName()).type(standardAttribute).build();
                } else {
                    attribute = Attribute.builder().name(field.getKeyName()).label(DataCloudMetadataHelper.getFieldLabel((KeyValuePairType)field)).tooltip(DataCloudMetadataHelper.getFieldHelpText((KeyValuePairType)field)).dataType(DataCloudMetadataHelper.dataTypeFromMetadataType((KeyValuePairType)field)).secure(Boolean.valueOf(DataCloudMetadataHelper.isFieldSecure((KeyValuePairType)field))).required(Boolean.valueOf(!field.isOptionalKey())).defaultValue(this.getFieldDefaultValue(field)).hidden(Boolean.valueOf(MetadataUtils.isHidden((DWType)field))).build();
                }
                result.add(attribute);
            }
        }
        return result;
    }

    private boolean isStandardAttribute(KeyValuePairType field) {
        return SUPPORTED_STANDARD_ATTRIBUTES.stream().anyMatch(a -> DataCloudMetadataHelper.hasSemanticTerm((KeyValuePairType)field, (String)a) && ((ArrayMetadataValue)((DWMetadata)field.getValue().getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).get()).getValue()).getElements().length == 1 && !DataCloudMetadataHelper.getMetadataFromField((KeyValuePairType)field, (String)MetadataKey.LABEL.getKey()).isPresent() && !DataCloudMetadataHelper.getMetadataFromField((KeyValuePairType)field, (String)MetadataKey.HELP_TEXT.getKey()).isPresent());
    }

    private @Nullable String getFieldDefaultValue(KeyValuePairType field) {
        return DataCloudMetadataHelper.getMetadataFromField((KeyValuePairType)field, (String)MetadataKey.DEFAULT_VALUE.getKey()).map(metadata -> MetadataValueUtils.asString((DWMetadataValue)metadata, (String)MetadataKey.DEFAULT_VALUE.getKey())).orElse(null);
    }

    private boolean isIgnoredField(KeyValuePairType field) {
        return DataCloudMetadataHelper.getMetadataFromField((KeyValuePairType)field, (String)"Ignore").isPresent();
    }

    private static ObjectType getObjectType(DataCloudConnectionModel connectionModel) {
        DataCloudConnectionProviderModel connectionProviderModel = connectionModel.getConnectionProviderModel();
        DWType rawInputType = connectionProviderModel.getInputType().getDataType();
        if (!(rawInputType instanceof ObjectType)) {
            rawInputType = WeaveTypeSimplifier.simplifyWeaveType((DWType)connectionProviderModel.getInputType().getDataType());
        }
        if (!(rawInputType instanceof ObjectType)) {
            throw new IllegalStateException(String.format("Expected Connection input type to be an object type (Connection : %s) ", connectionModel.getName()));
        }
        return (ObjectType)rawInputType;
    }
}

