/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.dc.maven.api.mojo;

import com.mulesoft.connectivity.datacloud.api.loader.DataCloudModelLoaderFactory;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectorModel;
import com.mulesoft.connectivity.dc.maven.api.mojo.AbstractDataCloudMojo;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.maven.api.model.Phase;
import com.mulesoft.connectivity.maven.api.model.Status;
import java.io.InputStream;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jspecify.annotations.NullMarked;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ModuleComponentsFactory;
import org.mule.weave.v2.runtime.SimpleModuleComponentFactory;

@NullMarked
@Mojo(name="validate", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE, threadSafe=true)
public class ConnectorValidationMojo
extends AbstractDataCloudMojo {
    private static final Pattern WIDTH_PATTERN = Pattern.compile("width=\"100(?:px|em|rem|ch|vw|vh|vmin|vmax|cm|mm|Q|in|pt|pc|ex|%|lh|rlh|vi|vb|dvw|dvh|dvi|dvb|lvw|lvh|lvi|lvb|svw|svh|svi|svb|cap|rcap)?\".*");
    private static final Pattern HEIGHT_PATTERN = Pattern.compile("height=\"100(?:px|em|rem|ch|vw|vh|vmin|vmax|cm|mm|Q|in|pt|pc|ex|%|lh|rlh|vi|vb|dvw|dvh|dvi|dvb|lvw|lvh|lvi|lvb|svw|svh|svi|svb|cap|rcap)?\".*");

    public void execute() throws MojoExecutionException {
        try {
            ConnectorValidationMojo.withContextClassLoader((ClassLoader)this.getCustomClassLoader(), () -> {
                DataWeaveScriptingEngine dataWeaveScriptingEngine = DataWeaveScriptingEngine.apply((ModuleComponentsFactory)SimpleModuleComponentFactory.apply());
                LanguageModelLoader modelLoader = new LanguageModelLoader(dataWeaveScriptingEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
                DataCloudConnectorModel connectorModel = (DataCloudConnectorModel)modelLoader.loadConnector(this.getConnectorLocator());
                this.validateConnectionIcon(connectorModel);
                if (connectorModel.getConfig() != null) {
                    this.validateConfiguration(connectorModel.getConfig());
                }
                this.writeMojoResult(Phase.VALIDATE, Status.SUCCESS);
                return null;
            });
        }
        catch (Exception ex) {
            this.writeMojoResult(Phase.VALIDATE, Status.FAILURE, ex.getCause(), Collections.emptyMap());
            throw new MojoExecutionException("Connector validation failed: " + ex.getMessage(), ex);
        }
    }

    private void validateConfiguration(Map<String, Object> config) throws MojoExecutionException {
        Map dateFormats = (Map)config.get("dateFormats");
        if (dateFormats == null || dateFormats.isEmpty()) {
            return;
        }
        try {
            new SimpleDateFormat((String)dateFormats.get("date"));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Invalid configuration for date format");
        }
        try {
            new SimpleDateFormat((String)dateFormats.get("date-time"));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Invalid configuration for date-time format");
        }
    }

    protected void validateConnectionIcon(DataCloudConnectorModel connectorModel) throws MojoExecutionException {
        String iconPath = Paths.get(String.format("ConnectionDefinition/%s.svg", connectorModel.getName()), new String[0]).toString();
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(iconPath);
        if (stream == null) {
            throw new MojoExecutionException("Icon was not found in " + iconPath);
        }
        Scanner scan = new Scanner(stream);
        HashSet<Pattern> requiredSet = new HashSet<Pattern>(Set.of(WIDTH_PATTERN, HEIGHT_PATTERN));
        while (scan.hasNext()) {
            String line = scan.nextLine();
            Objects.requireNonNull(line);
            requiredSet.removeIf(p -> p.matcher(line).find());
            if (line.contains("<image")) {
                throw new MojoExecutionException("Icon should not contain images");
            }
            if (!line.contains("href=\"data:image")) continue;
            throw new MojoExecutionException("Icon should not contain embedded images");
        }
        if (!requiredSet.isEmpty()) {
            throw new MojoExecutionException("Icon image is required to be 100x100");
        }
    }
}

