/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.fixengine.appliers;

import com.mulesoft.connectivity.codegen.internal.Helpers;
import com.mulesoft.connectivity.fixengine.MitigationIssue;
import com.mulesoft.connectivity.fixengine.PlatformGapsContext;
import com.mulesoft.connectivity.fixengine.api.strategies.ManageConnectionStrategy;
import com.mulesoft.connectivity.fixengine.appliers.AbstractVarDirectiveStrategyApplier;
import com.mulesoft.connectivity.fixengine.helper.AstHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.SimpleReferenceType;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode;
import org.mule.weave.v2.parser.ast.header.directives.VarDirective;
import org.mule.weave.v2.parser.ast.structure.KeyValuePairNode;
import org.mule.weave.v2.parser.ast.structure.ObjectNode;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class ManageConnectionStrategyApplier
extends AbstractVarDirectiveStrategyApplier<ManageConnectionStrategy.ManageConnectionSettings> {
    public static final String CONNECTIONS_KEY_NAME = "connections";

    public ManageConnectionStrategyApplier() {
        super(ManageConnectionStrategy.ManageConnectionSettings.class, ManageConnectionStrategy.class);
    }

    @Override
    public List<DirectiveNode> process(DirectiveNode directive, String moduleName, PlatformGapsContext context, ManageConnectionStrategy.ManageConnectionSettings settings) {
        return super.process(directive, moduleName, context, settings);
    }

    @Override
    protected boolean shouldSkipProcessing(PlatformGapsContext context) {
        return context.getConnectionIssues().isEmpty();
    }

    @Override
    protected List<DirectiveNode> processConnectorDirective(VarDirective varDirective, PlatformGapsContext context, ManageConnectionStrategy.ManageConnectionSettings settings) {
        MitigationIssue connectionIssue = context.getConnectionIssues().get(0);
        Map<String, SimpleReferenceType> connectionToType = ManageConnectionStrategyApplier.getConnectionTypes(connectionIssue);
        Collection<AstNode> connections = this.getNodes(varDirective, CONNECTIONS_KEY_NAME);
        List validConnectionNodes = settings.getConnectionPriority().stream().flatMap(conType -> connections.stream().filter(connection -> {
            String referenceTypeName = ((SimpleReferenceType)connectionToType.get(AstHelper.getPropertyName(connection))).getReferenceTypeName();
            return conType.accept(referenceTypeName);
        })).distinct().limit(settings.getMaxConnections().intValue()).toList();
        List<String> removedConnectionNames = connections.stream().filter(Predicate.not(validConnectionNodes::contains)).map(AstHelper::getPropertyName).toList();
        if (!removedConnectionNames.isEmpty()) {
            context.addConnectionMitigationMessage(connectionIssue, removedConnectionNames, this.getStrategyId());
        }
        return List.of(this.replaceField(varDirective, (Seq<AstNode>)Helpers.asSeq(validConnectionNodes)));
    }

    @Override
    protected String getConnectorAnnotation(ManageConnectionStrategy.ManageConnectionSettings settings) {
        return settings.getConnectorAnnotationPlatform();
    }

    private static Map<String, SimpleReferenceType> getConnectionTypes(MitigationIssue connectionIssue) {
        try {
            return Arrays.stream(((ObjectType)Arrays.stream(((ObjectType)connectionIssue.validatable().getElement()).getProperties()).filter(t -> t.getKeyName().equals(CONNECTIONS_KEY_NAME)).map(KeyValuePairType::getValue).toList().get(0)).getProperties()).collect(Collectors.toMap(KeyValuePairType::getKeyName, keyValuePairType -> (SimpleReferenceType)keyValuePairType.getValue().getBaseType()));
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Invalid connector structure", e);
        }
    }

    private VarDirective replaceField(VarDirective varDirective, Seq<AstNode> validOperations) {
        ObjectNode originalVarValue = (ObjectNode)varDirective.value();
        List<AstNode> filteredOperations = JavaConverters.asJavaCollection((Iterable)originalVarValue.children()).stream().map(child -> {
            if (this.isRequiredKeyValueNode((AstNode)child, CONNECTIONS_KEY_NAME)) {
                KeyValuePairNode originalOperationList = (KeyValuePairNode)child;
                ObjectNode originalNode = (ObjectNode)originalOperationList.value();
                AstNode key = originalOperationList.key();
                ObjectNode newOperationsObject = new ObjectNode(validOperations, originalNode.codeAnnotations());
                return new KeyValuePairNode(key, (AstNode)newOperationsObject, originalOperationList.cond());
            }
            return child;
        }).toList();
        ObjectNode newValue = new ObjectNode(JavaConverters.asScalaBuffer(filteredOperations).toSeq(), originalVarValue.codeAnnotations());
        return new VarDirective(varDirective.variable(), (AstNode)newValue, varDirective.wtype(), varDirective.codeAnnotations());
    }
}

