/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.fixengine;

import com.google.common.collect.ImmutableList;
import com.mulesoft.connectivity.fixengine.MitigationIssue;
import com.mulesoft.connectivity.fixengine.api.ConnectorComponentType;
import com.mulesoft.connectivity.validation.Issue;
import com.mulesoft.connectivity.validation.IssueSink;
import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.commons.compress.utils.Lists;
import org.jspecify.annotations.Nullable;

public class MitigationIssueSink
extends IssueSink {
    private static final List<ValidatableType> FIXABLE_COMPONENTS = ImmutableList.of((Object)ValidatableType.OPERATION, (Object)ValidatableType.CONNECTOR);
    private final List<MitigationIssue> mitigationIssues = Lists.newArrayList();

    public void accept(Issue issue, @Nullable Validatable<?> validatable) {
        if (issue.getLevel() == Issue.Level.ERROR && validatable != null) {
            validatable.getPath().map(Validatable::getTypes).flatMap(Collection::stream).filter(FIXABLE_COMPONENTS::contains).max(Comparator.naturalOrder()).ifPresent(type -> this.findAndAddIssueMessage(issue, validatable, (ValidatableType)type));
        }
    }

    private void findAndAddIssueMessage(Issue issue, Validatable<?> validatable, ValidatableType type) {
        validatable.getPath().filter(v -> v.hasType(type)).findFirst().ifPresent(element -> this.addIssue(issue, validatable, (Validatable<?>)element));
    }

    private void addIssue(Issue issue, Validatable<?> validatable, Validatable<?> component) {
        String subType = validatable.getTypes().stream().max(Comparator.naturalOrder()).map(Enum::name).orElse("");
        ConnectorComponentType rootComponentType = "Property 'connections' contains more than one connection".equals(issue.getMessage()) ? ConnectorComponentType.CONNECTION : component.getTypes().stream().filter(FIXABLE_COMPONENTS::contains).max(Comparator.naturalOrder()).map(Enum::name).map(ConnectorComponentType::valueOf).orElseThrow(() -> new IllegalArgumentException("Could not get the root component type"));
        this.mitigationIssues.add(new MitigationIssue(rootComponentType, component, subType, validatable, issue));
    }

    @Generated
    public List<MitigationIssue> getMitigationIssues() {
        return this.mitigationIssues;
    }
}

