/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.fixengine.utils.fakefile;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class MemoryURLConnection
extends URLConnection {
    private byte[] bytes;
    private InputStream in;

    MemoryURLConnection(URL u, byte[] bytes) {
        super(u);
        this.bytes = bytes;
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            if (this.bytes == null) {
                throw new FileNotFoundException(this.getURL().getPath());
            }
            this.in = new ByteArrayInputStream(this.bytes);
            this.connected = true;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.in;
    }

    @Override
    public long getContentLengthLong() {
        return this.bytes.length;
    }

    @Override
    public String getContentType() {
        return "application/octet-stream";
    }
}

