/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.fixengine.appliers;

import com.google.common.collect.ImmutableMap;
import com.mulesoft.connectivity.fixengine.MitigationPlatformTranslator;
import com.mulesoft.connectivity.fixengine.PlatformGapsContext;
import com.mulesoft.connectivity.fixengine.api.FixStrategy;
import com.mulesoft.connectivity.fixengine.api.ModuleResult;
import com.mulesoft.connectivity.fixengine.api.StrategySettings;
import com.mulesoft.connectivity.fixengine.appliers.StrategyApplier;
import com.mulesoft.connectivity.fixengine.appliers.StrategyAppliers;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class StrategyExecutor {
    private final Map<StrategyApplier<? extends StrategySettings>, ? extends StrategySettings> strategyAppliers;

    public StrategyExecutor(Map<StrategyApplier<? extends StrategySettings>, ? extends StrategySettings> strategiesById) {
        this.strategyAppliers = strategiesById;
    }

    public static StrategyExecutor buildInstance(MitigationPlatformTranslator platform, List<FixStrategy<? extends StrategySettings>> strategies) {
        ImmutableMap.Builder strategyBuilder = ImmutableMap.builder();
        strategies.forEach(strategy -> strategyBuilder.put(StrategyAppliers.getApplier(platform, strategy), strategy.getSettings()));
        return new StrategyExecutor((Map<StrategyApplier<? extends StrategySettings>, ? extends StrategySettings>)strategyBuilder.build());
    }

    public ModuleResult execute(PlatformGapsContext context, Map<String, ModuleNode> modules) {
        if (context.mitigationIssues().isEmpty()) {
            return new ModuleResult(modules, Collections.emptySet());
        }
        Map<String, ModuleNode> fixedModules = this.preProcess(context, modules);
        fixedModules = this.process(context, fixedModules);
        fixedModules = this.postProcess(context, fixedModules);
        return new ModuleResult(fixedModules, context.getMitigationMessages());
    }

    public Map<String, ModuleNode> process(PlatformGapsContext context, Map<String, ModuleNode> modules) {
        return modules.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entryModule -> {
            ModuleNode module = (ModuleNode)entryModule.getValue();
            List directives = JavaConverters.seqAsJavaList((Seq)module.directives());
            List fixedDirectives = directives.stream().map(directive -> this.fixDirective((DirectiveNode)directive, (String)entryModule.getKey(), context)).flatMap(Collection::stream).toList();
            return new ModuleNode(module.name(), JavaConverters.asScalaBuffer(fixedDirectives).toSeq());
        }));
    }

    private List<DirectiveNode> fixDirective(DirectiveNode directiveNode, String moduleName, PlatformGapsContext context) {
        List<Object> fixedDirectives = List.of(directiveNode);
        for (Map.Entry<StrategyApplier<? extends StrategySettings>, ? extends StrategySettings> entry : this.strategyAppliers.entrySet()) {
            StrategyApplier<? extends StrategySettings> applier = entry.getKey();
            StrategySettings settings = entry.getValue();
            fixedDirectives = fixedDirectives.stream().map(directive -> this.apply((DirectiveNode)directive, moduleName, (StrategyApplier)applier, context, (StrategySettings)settings)).flatMap(Collection::stream).toList();
        }
        return fixedDirectives;
    }

    private <ApplierSettings extends StrategySettings, Settings extends StrategySettings> List<DirectiveNode> apply(DirectiveNode directiveNode, String moduleName, StrategyApplier<ApplierSettings> applier, PlatformGapsContext context, @Nullable Settings settings) {
        return applier.process(directiveNode, moduleName, context, applier.accept(settings));
    }

    private <S extends StrategySettings> Map<String, ModuleNode> preProcess(PlatformGapsContext context, Map<String, ModuleNode> modules) {
        for (Map.Entry<StrategyApplier<? extends StrategySettings>, ? extends StrategySettings> entry : this.strategyAppliers.entrySet()) {
            StrategyApplier<? extends StrategySettings> applier = entry.getKey();
            StrategySettings settings = entry.getValue();
            modules = applier.preProcess(modules, context, settings);
        }
        return modules;
    }

    private <S extends StrategySettings> Map<String, ModuleNode> postProcess(PlatformGapsContext context, Map<String, ModuleNode> modules) {
        for (Map.Entry<StrategyApplier<? extends StrategySettings>, ? extends StrategySettings> entry : this.strategyAppliers.entrySet()) {
            StrategyApplier<? extends StrategySettings> applier = entry.getKey();
            StrategySettings settings = entry.getValue();
            modules = applier.postProcess(context, settings, modules);
        }
        return modules;
    }
}

