/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.fixengine.flow.applier;

import com.mulesoft.connectivity.fixengine.MitigationIssue;
import com.mulesoft.connectivity.fixengine.PlatformGapsContext;
import com.mulesoft.connectivity.fixengine.api.StrategySettings;
import com.mulesoft.connectivity.fixengine.api.strategies.RemoveUnsupportedOperationStrategy;
import com.mulesoft.connectivity.fixengine.appliers.AbstractVarDirectiveStrategyApplier;
import com.mulesoft.connectivity.fixengine.helper.AstHelper;
import com.mulesoft.connectivity.validation.Validatable;
import java.util.Optional;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode;
import org.mule.weave.v2.parser.ast.header.directives.VarDirective;
import org.mule.weave.v2.parser.ast.structure.KeyValuePairNode;
import org.mule.weave.v2.parser.ast.structure.ObjectNode;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.List;

public class FlowRemoveUnsupportedOperationStrategyApplier
extends AbstractVarDirectiveStrategyApplier<StrategySettings.UnusedStrategySettings> {
    public FlowRemoveUnsupportedOperationStrategyApplier() {
        super(StrategySettings.UnusedStrategySettings.class, RemoveUnsupportedOperationStrategy.class);
    }

    @Override
    protected boolean shouldSkipProcessing(PlatformGapsContext context) {
        return context.getOperationWithIssues().isEmpty();
    }

    @Override
    protected java.util.List<DirectiveNode> processConnectorDirective(VarDirective varDirective, PlatformGapsContext context, StrategySettings.UnusedStrategySettings settings) {
        return this.processConnectorDirective(varDirective, context);
    }

    @Override
    protected String getConnectorAnnotation(StrategySettings.UnusedStrategySettings settings) {
        return "FlowConnectorElement";
    }

    private java.util.List<DirectiveNode> processConnectorDirective(VarDirective varDirective, PlatformGapsContext context) {
        AstNode astNode = varDirective.value();
        if (!(astNode instanceof ObjectNode)) {
            throw new IllegalArgumentException("Could not find object node in varDirective");
        }
        ObjectNode nodeElements = (ObjectNode)astNode;
        KeyValuePairNode operationListNode = (KeyValuePairNode)nodeElements.children().find(node -> this.isRequiredKeyValueNode((AstNode)node, "operations")).getOrElse(() -> {
            throw new IllegalArgumentException("Could not find operation list in varDirective");
        });
        java.util.List operationsToExclude = context.getOperationWithIssues().stream().peek(issue -> context.addMitigationOmitOperationMessage((MitigationIssue)issue, this.getStrategyId())).map(MitigationIssue::rootValidatable).map(Validatable::getName).flatMap(Optional::stream).toList();
        List validOperations = ((Traversable)operationListNode.value().children().filterNot(operation -> operationsToExclude.contains(AstHelper.getPropertyName(operation)))).toList();
        return java.util.List.of(this.replaceOperationList(varDirective, (Seq<AstNode>)validOperations));
    }

    private VarDirective replaceOperationList(VarDirective varDirective, Seq<AstNode> validOperations) {
        ObjectNode originalVarValue = (ObjectNode)varDirective.value();
        java.util.List<AstNode> filteredOperations = JavaConverters.asJavaCollection((Iterable)originalVarValue.children()).stream().map(child -> {
            if (this.isRequiredKeyValueNode((AstNode)child, "operations")) {
                KeyValuePairNode originalOperationList = (KeyValuePairNode)child;
                ObjectNode originalNode = (ObjectNode)originalOperationList.value();
                AstNode key = originalOperationList.key();
                ObjectNode newOperationsObject = new ObjectNode(validOperations, originalNode.codeAnnotations());
                return new KeyValuePairNode(key, (AstNode)newOperationsObject, originalOperationList.cond());
            }
            return child;
        }).toList();
        ObjectNode newValue = new ObjectNode(JavaConverters.asScalaBuffer(filteredOperations).toSeq(), originalVarValue.codeAnnotations());
        return new VarDirective(varDirective.variable(), (AstNode)newValue, varDirective.wtype(), varDirective.codeAnnotations());
    }
}

