/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.fixengine;

import com.google.common.collect.Maps;
import com.mulesoft.connectivity.fixengine.MitigationIssue;
import com.mulesoft.connectivity.fixengine.api.ConnectorComponentType;
import com.mulesoft.connectivity.fixengine.api.report.ConnectionComponent;
import com.mulesoft.connectivity.fixengine.api.report.ConnectorComponent;
import com.mulesoft.connectivity.fixengine.api.report.MitigationMessage;
import com.mulesoft.connectivity.fixengine.api.report.OperationComponent;
import com.mulesoft.connectivity.fixengine.api.report.TypeComponent;
import com.mulesoft.connectivity.fixengine.types.TypeIndexer;
import com.mulesoft.connectivity.linkweave.api.model.CodeSourceLocation;
import com.mulesoft.connectivity.validation.Validatable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.location.Location;
import org.mule.weave.v2.ts.WeaveType;

public class PlatformGapsContext {
    public static final String OMIT_OPERATION_MESSAGE = "Omit operation";
    private final TypeIndexer typeIndexer;
    private final List<MitigationIssue> mitigationIssues;
    private final Map<MitigationIssue, MitigationMessage<?, ?>> mitigationMessages;
    private final Map<String, CodeSourceLocation> operationLocations;

    public PlatformGapsContext(List<MitigationIssue> mitigationIssues, Map<String, CodeSourceLocation> opLocations) {
        this.mitigationIssues = mitigationIssues;
        this.mitigationMessages = Maps.newHashMap();
        this.typeIndexer = new TypeIndexer();
        this.operationLocations = opLocations;
    }

    public List<MitigationIssue> getOperationWithIssues() {
        return this.mitigationIssues.stream().filter(Predicate.not(this.mitigationMessages::containsKey)).filter(mitigationMessage -> ConnectorComponentType.OPERATION.equals((Object)mitigationMessage.rootComponentType())).toList();
    }

    public Set<MitigationMessage<?, ?>> getMitigationMessages() {
        return new HashSet(this.mitigationMessages.values());
    }

    public void addMitigationMessage(MitigationIssue issue, MitigationMessage<?, ?> message) {
        this.mitigationMessages.put(issue, message);
    }

    public TypeIndexer typeIndexer() {
        return this.typeIndexer;
    }

    public List<MitigationIssue> mitigationIssues() {
        return this.mitigationIssues;
    }

    public void addMitigationRewrittenTypeMessage(MitigationIssue issue, String newTypeName, String strategyId) {
        String componentName = issue.validatable().getName().orElse("");
        String mitigationMessage = "Rewritten type: %s".formatted(newTypeName);
        MitigationMessage<OperationComponent, TypeComponent> message = MitigationMessage.builder().rootComponent(this.buildOperationComponent(issue)).component(this.buildTypeComponent(componentName, issue, issue.validatable().getLocation(), newTypeName)).mitigationMessage(mitigationMessage).errorMessage(issue.issue().getMessage()).strategyId(strategyId).build();
        this.addMitigationMessage(issue, message);
    }

    public void addMitigationOmitOperationMessage(MitigationIssue issue, String strategyId) {
        String componentName = issue.validatable().getName().orElse("");
        MitigationMessage<OperationComponent, TypeComponent> mitigationMessage = MitigationMessage.builder().rootComponent(this.buildOperationComponent(issue)).component(this.buildTypeComponent(componentName, issue, this.getLocation(issue), null)).mitigationMessage(OMIT_OPERATION_MESSAGE).errorMessage(issue.issue().getMessage()).strategyId(strategyId).build();
        this.addMitigationMessage(issue, mitigationMessage);
    }

    private @Nullable Location getLocation(MitigationIssue issue) {
        Object object = issue.validatable().getElement();
        if (object instanceof WeaveType) {
            WeaveType wt = (WeaveType)object;
            return wt.getLocation();
        }
        return null;
    }

    private TypeComponent buildTypeComponent(String componentName, MitigationIssue issue, @Nullable Location location, @Nullable String newTypeName) {
        return TypeComponent.builder().name(componentName).fieldType(issue.validatable().getElement().toString()).location(location).path(issue.validatable().pathDescription()).newTypeName(newTypeName).build();
    }

    private OperationComponent buildOperationComponent(MitigationIssue issue) {
        return OperationComponent.builder().name(issue.rootValidatable().getName().orElse("")).location(issue.rootValidatable().getLocation()).path(issue.rootValidatable().pathDescription()).build();
    }

    public List<MitigationIssue> getConnectionIssues() {
        return this.mitigationIssues.stream().filter(Predicate.not(this.mitigationMessages::containsKey)).filter(mitigationMessage -> ConnectorComponentType.CONNECTION.equals((Object)mitigationMessage.rootComponentType())).toList();
    }

    public void addConnectionMitigationMessage(MitigationIssue connectionIssue, String connectionName, String strategyId) {
        String path = Optional.ofNullable(connectionIssue.validatable().getParent()).map(Validatable::pathDescription).orElse(null);
        MitigationMessage<ConnectorComponent, ConnectionComponent> mitigationMessage = MitigationMessage.builder().rootComponent(new ConnectorComponent(path)).component(new ConnectionComponent(connectionName, connectionIssue.validatable().pathDescription())).mitigationMessage("Remove connection %s".formatted(connectionName)).errorMessage(connectionIssue.issue().getMessage()).strategyId(strategyId).build();
        this.addMitigationMessage(connectionIssue, mitigationMessage);
    }

    @Generated
    public Map<String, CodeSourceLocation> getOperationLocations() {
        return this.operationLocations;
    }
}

