/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.fixengine.flow;

import com.google.common.collect.Maps;
import com.mulesoft.connectivity.codegen.api.flow.FlowTranslator;
import com.mulesoft.connectivity.codegen.api.flow.config.FlowTranslatorConfig;
import com.mulesoft.connectivity.fixengine.MitigationIssue;
import com.mulesoft.connectivity.fixengine.MitigationIssueSink;
import com.mulesoft.connectivity.fixengine.MitigationPlatformTranslator;
import com.mulesoft.connectivity.fixengine.PlatformGapsContext;
import com.mulesoft.connectivity.fixengine.api.FlowTranslatorMitigationConfig;
import com.mulesoft.connectivity.fixengine.api.ModuleResult;
import com.mulesoft.connectivity.fixengine.appliers.StrategyExecutor;
import com.mulesoft.connectivity.fixengine.utils.ConnectorTranslatorUtils;
import com.mulesoft.connectivity.fixengine.utils.OperationTuple;
import com.mulesoft.connectivity.fixengine.utils.ParserUtils;
import com.mulesoft.connectivity.fixengine.utils.VirtualFSClassLoader;
import com.mulesoft.connectivity.flow.api.validator.FlowValidationConfiguration;
import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.CodeSourceLocation;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.validation.ConnectorValidationAnnotationProcessor;
import com.mulesoft.connectivity.validation.IssueSink;
import com.mulesoft.connectivity.validation.ValidationConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.compress.utils.Lists;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.annotation.DWAbstractTypeAnnotationProcessor;
import org.mule.weave.v2.api.tooling.annotation.DWAnnotationContext;
import org.mule.weave.v2.codegen.CodeGenerator$;
import org.mule.weave.v2.codegen.CodeGeneratorSettings;
import org.mule.weave.v2.codegen.InfixOptions;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.parser.phase.TypeCheckingResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterable;
import scala.collection.JavaConverters;

public final class MitigationFlowTranslator
implements MitigationPlatformTranslator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MitigationFlowTranslator.class);
    private final FlowTranslatorConfig config;
    private final @Nullable StrategyExecutor strategyExecutor;
    private final String[] modules;

    public MitigationFlowTranslator(FlowTranslatorMitigationConfig config, String ... modules) {
        this.modules = modules;
        this.config = config;
        this.strategyExecutor = config.getFixStrategies() != null && !config.getFixStrategies().isEmpty() ? StrategyExecutor.buildInstance(this, config.getFixStrategies()) : null;
    }

    private Map<String, ModuleNode> getModules(Function<List<OperationModel>, List<OperationModel>> operationSelector) {
        FlowTranslator flowTranslator = FlowTranslator.fromModules((FlowTranslatorConfig)this.config, (String[])this.modules);
        ArrayList selectedOperations = Lists.newArrayList();
        ArrayList allOperations = Lists.newArrayList();
        flowTranslator.selectOperations(operations -> {
            allOperations.addAll(operations);
            List filtered = (List)operationSelector.apply(allOperations);
            selectedOperations.addAll(filtered);
            return filtered;
        });
        return this.fixPaginatedOperationsTypesImports(flowTranslator.getModules(), selectedOperations, allOperations);
    }

    private Map<String, ModuleNode> fixPaginatedOperationsTypesImports(Map<String, ModuleNode> modules, List<OperationModel> selectedOperations, List<OperationModel> allOperations) {
        Map paginatedToNotPaginatedOp = selectedOperations.stream().filter(BaseExecutableComponentModel::isPaginated).map(paginatedOp -> {
            OperationModel operation = allOperations.stream().filter(op -> !op.isPaginated() && op.getName().equals(paginatedOp.getName())).findFirst().orElseThrow();
            return new OperationTuple(operation, (OperationModel)paginatedOp);
        }).collect(Collectors.toMap(tuple -> {
            CodeSourceLocation location = this.config.getCustomizationHandler().getLocationForOperation((Object)tuple.paginatedOp());
            return String.join((CharSequence)"::", location.getModuleParts());
        }, Function.identity()));
        return modules.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Optional.ofNullable((OperationTuple)paginatedToNotPaginatedOp.get(entry.getKey())).map(tuple -> ConnectorTranslatorUtils.fixModuleImports((ModuleNode)entry.getValue(), tuple)).orElse((ModuleNode)entry.getValue())));
    }

    public ModuleResult buildModules(Function<List<OperationModel>, List<OperationModel>> selectedOperations) {
        if (this.strategyExecutor != null) {
            HashMap opLocations = Maps.newHashMap();
            selectedOperations = selectedOperations.andThen(ops -> {
                ops.forEach(op -> opLocations.put(op.getName(), this.config.getCustomizationHandler().getLocationForOperation(op)));
                return ops;
            });
            return this.fixModules(this.getModules(selectedOperations), opLocations);
        }
        return new ModuleResult(this.getModules(selectedOperations), Collections.emptySet());
    }

    private ModuleResult fixModules(Map<String, ModuleNode> modules, Map<String, CodeSourceLocation> opLocations) {
        try {
            Objects.requireNonNull(this.strategyExecutor);
            PlatformGapsContext context = new PlatformGapsContext(this.parseModule(modules), opLocations);
            return this.strategyExecutor.execute(context, modules);
        }
        catch (Exception e) {
            log.error("Unexpected error occurred applying mitigations", (Throwable)e);
            return new ModuleResult(modules, e);
        }
    }

    /*
     * Loose catch block
     */
    private List<MitigationIssue> parseModule(Map<String, ModuleNode> modules) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            PhaseResult<TypeCheckingResult<ModuleNode>> result;
            block12: {
                List<MitigationIssue> list;
                block13: {
                    Map<String, String> resources = MitigationFlowTranslator.getResources(modules);
                    VirtualFSClassLoader loader = VirtualFSClassLoader.create(resources, currentClassLoader);
                    Thread.currentThread().setContextClassLoader(loader);
                    final MitigationIssueSink mitigationIssueSink = new MitigationIssueSink();
                    ConnectorValidationAnnotationProcessor processor = new ConnectorValidationAnnotationProcessor((ValidationConfiguration)new FlowValidationConfiguration()){

                        protected IssueSink getIssueSink(DWAnnotationContext context) {
                            return super.getIssueSink(context).andThen((IssueSink)mitigationIssueSink);
                        }
                    };
                    String mainModuleResource = String.join((CharSequence)"/", this.config.getCustomizationHandler().getLocationForConnector().getModuleParts()) + ".dwl";
                    result = ParserUtils.parseModule(resources.get(mainModuleResource), (DWAbstractTypeAnnotationProcessor)processor, "com::mulesoft::connectivity::flow::Metadata::FlowConnectorElement");
                    if (result.errorMessages().size() != mitigationIssueSink.getMitigationIssues().size()) break block12;
                    list = mitigationIssueSink.getMitigationIssues();
                    if (loader == null) break block13;
                    {
                        catch (Throwable throwable) {
                            if (loader != null) {
                                try {
                                    loader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    loader.close();
                }
                return list;
            }
            try {
                throw new IllegalStateException("Failed to parse generated modules: \n" + JavaConverters.asJavaCollection((Iterable)result.errorMessages()).stream().map(Objects::toString).collect(Collectors.joining("\n")));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private static Map<String, String> getResources(Map<String, ModuleNode> modules) {
        CodeGeneratorSettings settings = CodeGeneratorSettings.apply((int)InfixOptions.KEEP(), (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        Function<Map.Entry, String> getKey = e -> String.join((CharSequence)"/", ((String)e.getKey()).split("::")).concat(".dwl");
        Function<Map.Entry, String> value = e -> CodeGenerator$.MODULE$.generate((AstNode)e.getValue(), settings);
        return modules.entrySet().stream().collect(Collectors.toMap(getKey, value));
    }
}

