/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.fixengine.types;

import com.mulesoft.connectivity.fixengine.reconstruction.ArrayTypeRebuildBlueprint;
import com.mulesoft.connectivity.fixengine.reconstruction.FieldReplacementInstruction;
import com.mulesoft.connectivity.fixengine.reconstruction.ImportDirectiveRebuildBlueprint;
import com.mulesoft.connectivity.fixengine.reconstruction.ObjectTypeRebuildBlueprint;
import com.mulesoft.connectivity.fixengine.reconstruction.RebuildBlueprint;
import com.mulesoft.connectivity.fixengine.reconstruction.TypeDirectiveRebuildBlueprint;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.utils.Lists;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ReferenceType;
import org.mule.weave.v2.ts.ArrayType;
import org.mule.weave.v2.ts.ObjectType;

public class TypeIndexer {
    private final Map<String, RebuildBlueprint<?>> domainTypeReplacements;
    private final Map<String, ImportDirectiveRebuildBlueprint> importsPerModule;
    private final Map<String, List<RebuildBlueprint<?>>> operationReplacements;
    private final Set<ReferenceType> usedReferenceTypes = new HashSet<ReferenceType>();

    public TypeIndexer() {
        this.domainTypeReplacements = new HashMap();
        this.importsPerModule = new HashMap<String, ImportDirectiveRebuildBlueprint>();
        this.operationReplacements = new HashMap();
    }

    public <T extends RebuildBlueprint<?>> Optional<T> getOperationReplacementBlueprint(String operationName, Class<T> blueprintClass) {
        return Optional.ofNullable(this.operationReplacements.get(operationName)).flatMap(rebuildBlueprints -> rebuildBlueprints.stream().filter(blueprintClass::isInstance).findFirst()).map(blueprintClass::cast);
    }

    public Optional<ImportDirectiveRebuildBlueprint> getImportsForModule(String module) {
        return Optional.ofNullable(this.importsPerModule.get(module));
    }

    public void addTypeForImport(String module, String typeName) {
        ImportDirectiveRebuildBlueprint blueprint = this.importsPerModule.computeIfAbsent(module, key -> new ImportDirectiveRebuildBlueprint());
        blueprint.addImportedElement(typeName);
    }

    public Collection<RebuildBlueprint<?>> getDomainReplacements() {
        return this.domainTypeReplacements.values();
    }

    public Optional<RebuildBlueprint<?>> getTypeReplacement(DWType dwType) {
        return this.getTypeReplacement(dwType.toString());
    }

    public Optional<RebuildBlueprint<?>> getTypeReplacement(String key) {
        return Optional.ofNullable(this.domainTypeReplacements.get(key));
    }

    public <T extends RebuildBlueprint<?>> T computeTypeReplacement(DWType dwType, Supplier<T> typeReplacementSupplier) {
        return (T)this.domainTypeReplacements.computeIfAbsent(dwType.toString(), k -> (RebuildBlueprint)typeReplacementSupplier.get());
    }

    public TypeDirectiveRebuildBlueprint addTypeDirectiveReplacement(DWType indexKey, DWType replacedType, String newTypeName) {
        RebuildBlueprint<?> typeRebuildBlueprint = this.getTypeReplacement(replacedType).orElseThrow(() -> new IllegalStateException("Type replacement missing for Type: " + String.valueOf(replacedType)));
        return this.computeTypeReplacement(indexKey, () -> new TypeDirectiveRebuildBlueprint(newTypeName, typeRebuildBlueprint, this));
    }

    public ObjectTypeRebuildBlueprint addObjectTypeReplacement(ObjectType parentObject) {
        return this.computeTypeReplacement((DWType)parentObject, () -> new ObjectTypeRebuildBlueprint(parentObject, this));
    }

    public ObjectTypeRebuildBlueprint addObjectTypeReplacement(ObjectType parentObject, FieldReplacementInstruction ... fieldReplacementInstructions) {
        ObjectTypeRebuildBlueprint typeRebuildBlueprint = this.addObjectTypeReplacement(parentObject);
        Stream.of(fieldReplacementInstructions).forEach(typeRebuildBlueprint::addInstruction);
        return typeRebuildBlueprint;
    }

    public ArrayTypeRebuildBlueprint addArrayTypeReplacement(ArrayType parentArray) {
        return this.computeTypeReplacement((DWType)parentArray, () -> new ArrayTypeRebuildBlueprint(this, parentArray));
    }

    public void addReferenceType(ReferenceType referenceType) {
        this.usedReferenceTypes.add(referenceType);
    }

    public Collection<ReferenceType> getUnmodifiedTypes() {
        List<String> rewrittenTypes = this.domainTypeReplacements.values().stream().filter(tr -> tr instanceof TypeDirectiveRebuildBlueprint).map(tr -> ((TypeDirectiveRebuildBlueprint)tr).getName()).toList();
        return this.usedReferenceTypes.stream().filter(Predicate.not(type -> rewrittenTypes.contains(type.getReferenceTypeName()))).collect(Collectors.toMap(ReferenceType::getReferenceFQName, Function.identity(), (t1, t2) -> t1)).values();
    }

    public void addOperationReplacement(String moduleName, RebuildBlueprint<?> blueprint) {
        this.operationReplacements.compute(moduleName, (key, list) -> {
            list = Optional.ofNullable(list).orElseGet(Lists::newArrayList);
            list.add(blueprint);
            return list;
        });
    }
}

